/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.CancelExecutionWindowDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CancelExecutionWindowRequest
extends BmcRequest<CancelExecutionWindowDetails> {
    private String executionWindowId;
    private CancelExecutionWindowDetails cancelExecutionWindowDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getExecutionWindowId() {
        return this.executionWindowId;
    }

    public CancelExecutionWindowDetails getCancelExecutionWindowDetails() {
        return this.cancelExecutionWindowDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CancelExecutionWindowDetails getBody$() {
        return this.cancelExecutionWindowDetails;
    }

    public Builder toBuilder() {
        return new Builder().executionWindowId(this.executionWindowId).cancelExecutionWindowDetails(this.cancelExecutionWindowDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",executionWindowId=").append(String.valueOf(this.executionWindowId));
        sb.append(",cancelExecutionWindowDetails=").append(String.valueOf((Object)this.cancelExecutionWindowDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CancelExecutionWindowRequest)) {
            return false;
        }
        CancelExecutionWindowRequest other = (CancelExecutionWindowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.executionWindowId, other.executionWindowId) && Objects.equals((Object)this.cancelExecutionWindowDetails, (Object)other.cancelExecutionWindowDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.executionWindowId == null ? 43 : this.executionWindowId.hashCode());
        result = result * 59 + (this.cancelExecutionWindowDetails == null ? 43 : this.cancelExecutionWindowDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelExecutionWindowRequest, CancelExecutionWindowDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String executionWindowId = null;
        private CancelExecutionWindowDetails cancelExecutionWindowDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder executionWindowId(String executionWindowId) {
            this.executionWindowId = executionWindowId;
            return this;
        }

        public Builder cancelExecutionWindowDetails(CancelExecutionWindowDetails cancelExecutionWindowDetails) {
            this.cancelExecutionWindowDetails = cancelExecutionWindowDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelExecutionWindowRequest o) {
            this.executionWindowId(o.getExecutionWindowId());
            this.cancelExecutionWindowDetails(o.getCancelExecutionWindowDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelExecutionWindowRequest build() {
            CancelExecutionWindowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CancelExecutionWindowDetails body) {
            this.cancelExecutionWindowDetails(body);
            return this;
        }

        public CancelExecutionWindowRequest buildWithoutInvocationCallback() {
            CancelExecutionWindowRequest request = new CancelExecutionWindowRequest();
            request.executionWindowId = this.executionWindowId;
            request.cancelExecutionWindowDetails = this.cancelExecutionWindowDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

