/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DayOfWeek;
import com.oracle.bmc.database.model.Month;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WindowPreferenceDetail
extends ExplicitlySetBmcModel {
    @JsonProperty(value="months")
    private final List<Month> months;
    @JsonProperty(value="weeksOfMonth")
    private final List<Integer> weeksOfMonth;
    @JsonProperty(value="daysOfWeek")
    private final List<DayOfWeek> daysOfWeek;
    @JsonProperty(value="startTime")
    private final String startTime;
    @JsonProperty(value="duration")
    private final Integer duration;
    @JsonProperty(value="isEnforcedDuration")
    private final Boolean isEnforcedDuration;

    @Deprecated
    @ConstructorProperties(value={"months", "weeksOfMonth", "daysOfWeek", "startTime", "duration", "isEnforcedDuration"})
    public WindowPreferenceDetail(List<Month> months, List<Integer> weeksOfMonth, List<DayOfWeek> daysOfWeek, String startTime, Integer duration, Boolean isEnforcedDuration) {
        this.months = months;
        this.weeksOfMonth = weeksOfMonth;
        this.daysOfWeek = daysOfWeek;
        this.startTime = startTime;
        this.duration = duration;
        this.isEnforcedDuration = isEnforcedDuration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<Month> getMonths() {
        return this.months;
    }

    public List<Integer> getWeeksOfMonth() {
        return this.weeksOfMonth;
    }

    public List<DayOfWeek> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Boolean getIsEnforcedDuration() {
        return this.isEnforcedDuration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WindowPreferenceDetail(");
        sb.append("super=").append(super.toString());
        sb.append("months=").append(String.valueOf(this.months));
        sb.append(", weeksOfMonth=").append(String.valueOf(this.weeksOfMonth));
        sb.append(", daysOfWeek=").append(String.valueOf(this.daysOfWeek));
        sb.append(", startTime=").append(String.valueOf(this.startTime));
        sb.append(", duration=").append(String.valueOf(this.duration));
        sb.append(", isEnforcedDuration=").append(String.valueOf(this.isEnforcedDuration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowPreferenceDetail)) {
            return false;
        }
        WindowPreferenceDetail other = (WindowPreferenceDetail)((Object)o);
        return Objects.equals(this.months, other.months) && Objects.equals(this.weeksOfMonth, other.weeksOfMonth) && Objects.equals(this.daysOfWeek, other.daysOfWeek) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.duration, other.duration) && Objects.equals(this.isEnforcedDuration, other.isEnforcedDuration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.months == null ? 43 : this.months.hashCode());
        result = result * 59 + (this.weeksOfMonth == null ? 43 : this.weeksOfMonth.hashCode());
        result = result * 59 + (this.daysOfWeek == null ? 43 : this.daysOfWeek.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.duration == null ? 43 : this.duration.hashCode());
        result = result * 59 + (this.isEnforcedDuration == null ? 43 : this.isEnforcedDuration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="months")
        private List<Month> months;
        @JsonProperty(value="weeksOfMonth")
        private List<Integer> weeksOfMonth;
        @JsonProperty(value="daysOfWeek")
        private List<DayOfWeek> daysOfWeek;
        @JsonProperty(value="startTime")
        private String startTime;
        @JsonProperty(value="duration")
        private Integer duration;
        @JsonProperty(value="isEnforcedDuration")
        private Boolean isEnforcedDuration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder months(List<Month> months) {
            this.months = months;
            this.__explicitlySet__.add("months");
            return this;
        }

        public Builder weeksOfMonth(List<Integer> weeksOfMonth) {
            this.weeksOfMonth = weeksOfMonth;
            this.__explicitlySet__.add("weeksOfMonth");
            return this;
        }

        public Builder daysOfWeek(List<DayOfWeek> daysOfWeek) {
            this.daysOfWeek = daysOfWeek;
            this.__explicitlySet__.add("daysOfWeek");
            return this;
        }

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            this.__explicitlySet__.add("startTime");
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.__explicitlySet__.add("duration");
            return this;
        }

        public Builder isEnforcedDuration(Boolean isEnforcedDuration) {
            this.isEnforcedDuration = isEnforcedDuration;
            this.__explicitlySet__.add("isEnforcedDuration");
            return this;
        }

        public WindowPreferenceDetail build() {
            WindowPreferenceDetail model = new WindowPreferenceDetail(this.months, this.weeksOfMonth, this.daysOfWeek, this.startTime, this.duration, this.isEnforcedDuration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WindowPreferenceDetail model) {
            if (model.wasPropertyExplicitlySet("months")) {
                this.months(model.getMonths());
            }
            if (model.wasPropertyExplicitlySet("weeksOfMonth")) {
                this.weeksOfMonth(model.getWeeksOfMonth());
            }
            if (model.wasPropertyExplicitlySet("daysOfWeek")) {
                this.daysOfWeek(model.getDaysOfWeek());
            }
            if (model.wasPropertyExplicitlySet("startTime")) {
                this.startTime(model.getStartTime());
            }
            if (model.wasPropertyExplicitlySet("duration")) {
                this.duration(model.getDuration());
            }
            if (model.wasPropertyExplicitlySet("isEnforcedDuration")) {
                this.isEnforcedDuration(model.getIsEnforcedDuration());
            }
            return this;
        }
    }
}

