/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.ActionMember;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RecommendedScheduledActionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="actionOrder")
    private final Integer actionOrder;
    @JsonProperty(value="actionType")
    private final ActionType actionType;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="schedulingWindowId")
    private final String schedulingWindowId;
    @JsonProperty(value="estimatedTimeInMins")
    private final Integer estimatedTimeInMins;
    @JsonProperty(value="actionMembers")
    private final List<ActionMember> actionMembers;
    @JsonProperty(value="actionParams")
    private final Map<String, String> actionParams;

    @Deprecated
    @ConstructorProperties(value={"actionOrder", "actionType", "displayName", "schedulingWindowId", "estimatedTimeInMins", "actionMembers", "actionParams"})
    public RecommendedScheduledActionSummary(Integer actionOrder, ActionType actionType, String displayName, String schedulingWindowId, Integer estimatedTimeInMins, List<ActionMember> actionMembers, Map<String, String> actionParams) {
        this.actionOrder = actionOrder;
        this.actionType = actionType;
        this.displayName = displayName;
        this.schedulingWindowId = schedulingWindowId;
        this.estimatedTimeInMins = estimatedTimeInMins;
        this.actionMembers = actionMembers;
        this.actionParams = actionParams;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getActionOrder() {
        return this.actionOrder;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSchedulingWindowId() {
        return this.schedulingWindowId;
    }

    public Integer getEstimatedTimeInMins() {
        return this.estimatedTimeInMins;
    }

    public List<ActionMember> getActionMembers() {
        return this.actionMembers;
    }

    public Map<String, String> getActionParams() {
        return this.actionParams;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RecommendedScheduledActionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("actionOrder=").append(String.valueOf(this.actionOrder));
        sb.append(", actionType=").append(String.valueOf((Object)this.actionType));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", schedulingWindowId=").append(String.valueOf(this.schedulingWindowId));
        sb.append(", estimatedTimeInMins=").append(String.valueOf(this.estimatedTimeInMins));
        sb.append(", actionMembers=").append(String.valueOf(this.actionMembers));
        sb.append(", actionParams=").append(String.valueOf(this.actionParams));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecommendedScheduledActionSummary)) {
            return false;
        }
        RecommendedScheduledActionSummary other = (RecommendedScheduledActionSummary)((Object)o);
        return Objects.equals(this.actionOrder, other.actionOrder) && Objects.equals((Object)this.actionType, (Object)other.actionType) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.schedulingWindowId, other.schedulingWindowId) && Objects.equals(this.estimatedTimeInMins, other.estimatedTimeInMins) && Objects.equals(this.actionMembers, other.actionMembers) && Objects.equals(this.actionParams, other.actionParams) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.actionOrder == null ? 43 : this.actionOrder.hashCode());
        result = result * 59 + (this.actionType == null ? 43 : this.actionType.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.schedulingWindowId == null ? 43 : this.schedulingWindowId.hashCode());
        result = result * 59 + (this.estimatedTimeInMins == null ? 43 : this.estimatedTimeInMins.hashCode());
        result = result * 59 + (this.actionMembers == null ? 43 : this.actionMembers.hashCode());
        result = result * 59 + (this.actionParams == null ? 43 : this.actionParams.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ActionType implements BmcEnum
    {
        DbServerFullSoftwareUpdate("DB_SERVER_FULL_SOFTWARE_UPDATE"),
        StorageServerFullSoftwareUpdate("STORAGE_SERVER_FULL_SOFTWARE_UPDATE"),
        NetworkSwitchFullSoftwareUpdate("NETWORK_SWITCH_FULL_SOFTWARE_UPDATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActionType> map;

        private ActionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActionType.class);
            map = new HashMap<String, ActionType>();
            for (ActionType v : ActionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="actionOrder")
        private Integer actionOrder;
        @JsonProperty(value="actionType")
        private ActionType actionType;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="schedulingWindowId")
        private String schedulingWindowId;
        @JsonProperty(value="estimatedTimeInMins")
        private Integer estimatedTimeInMins;
        @JsonProperty(value="actionMembers")
        private List<ActionMember> actionMembers;
        @JsonProperty(value="actionParams")
        private Map<String, String> actionParams;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder actionOrder(Integer actionOrder) {
            this.actionOrder = actionOrder;
            this.__explicitlySet__.add("actionOrder");
            return this;
        }

        public Builder actionType(ActionType actionType) {
            this.actionType = actionType;
            this.__explicitlySet__.add("actionType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder schedulingWindowId(String schedulingWindowId) {
            this.schedulingWindowId = schedulingWindowId;
            this.__explicitlySet__.add("schedulingWindowId");
            return this;
        }

        public Builder estimatedTimeInMins(Integer estimatedTimeInMins) {
            this.estimatedTimeInMins = estimatedTimeInMins;
            this.__explicitlySet__.add("estimatedTimeInMins");
            return this;
        }

        public Builder actionMembers(List<ActionMember> actionMembers) {
            this.actionMembers = actionMembers;
            this.__explicitlySet__.add("actionMembers");
            return this;
        }

        public Builder actionParams(Map<String, String> actionParams) {
            this.actionParams = actionParams;
            this.__explicitlySet__.add("actionParams");
            return this;
        }

        public RecommendedScheduledActionSummary build() {
            RecommendedScheduledActionSummary model = new RecommendedScheduledActionSummary(this.actionOrder, this.actionType, this.displayName, this.schedulingWindowId, this.estimatedTimeInMins, this.actionMembers, this.actionParams);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RecommendedScheduledActionSummary model) {
            if (model.wasPropertyExplicitlySet("actionOrder")) {
                this.actionOrder(model.getActionOrder());
            }
            if (model.wasPropertyExplicitlySet("actionType")) {
                this.actionType(model.getActionType());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("schedulingWindowId")) {
                this.schedulingWindowId(model.getSchedulingWindowId());
            }
            if (model.wasPropertyExplicitlySet("estimatedTimeInMins")) {
                this.estimatedTimeInMins(model.getEstimatedTimeInMins());
            }
            if (model.wasPropertyExplicitlySet("actionMembers")) {
                this.actionMembers(model.getActionMembers());
            }
            if (model.wasPropertyExplicitlySet("actionParams")) {
                this.actionParams(model.getActionParams());
            }
            return this;
        }
    }
}

