/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FlexComponentSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="minimumCoreCount")
    private final Integer minimumCoreCount;
    @JsonProperty(value="availableCoreCount")
    private final Integer availableCoreCount;
    @JsonProperty(value="availableDbStorageInGBs")
    private final Integer availableDbStorageInGBs;
    @JsonProperty(value="runtimeMinimumCoreCount")
    private final Integer runtimeMinimumCoreCount;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="availableMemoryInGBs")
    private final Integer availableMemoryInGBs;
    @JsonProperty(value="availableLocalStorageInGBs")
    private final Integer availableLocalStorageInGBs;
    @JsonProperty(value="computeModel")
    private final String computeModel;
    @JsonProperty(value="hardwareType")
    private final HardwareType hardwareType;
    @JsonProperty(value="descriptionSummary")
    private final String descriptionSummary;

    @Deprecated
    @ConstructorProperties(value={"name", "minimumCoreCount", "availableCoreCount", "availableDbStorageInGBs", "runtimeMinimumCoreCount", "shape", "availableMemoryInGBs", "availableLocalStorageInGBs", "computeModel", "hardwareType", "descriptionSummary"})
    public FlexComponentSummary(String name, Integer minimumCoreCount, Integer availableCoreCount, Integer availableDbStorageInGBs, Integer runtimeMinimumCoreCount, String shape, Integer availableMemoryInGBs, Integer availableLocalStorageInGBs, String computeModel, HardwareType hardwareType, String descriptionSummary) {
        this.name = name;
        this.minimumCoreCount = minimumCoreCount;
        this.availableCoreCount = availableCoreCount;
        this.availableDbStorageInGBs = availableDbStorageInGBs;
        this.runtimeMinimumCoreCount = runtimeMinimumCoreCount;
        this.shape = shape;
        this.availableMemoryInGBs = availableMemoryInGBs;
        this.availableLocalStorageInGBs = availableLocalStorageInGBs;
        this.computeModel = computeModel;
        this.hardwareType = hardwareType;
        this.descriptionSummary = descriptionSummary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getMinimumCoreCount() {
        return this.minimumCoreCount;
    }

    public Integer getAvailableCoreCount() {
        return this.availableCoreCount;
    }

    public Integer getAvailableDbStorageInGBs() {
        return this.availableDbStorageInGBs;
    }

    public Integer getRuntimeMinimumCoreCount() {
        return this.runtimeMinimumCoreCount;
    }

    public String getShape() {
        return this.shape;
    }

    public Integer getAvailableMemoryInGBs() {
        return this.availableMemoryInGBs;
    }

    public Integer getAvailableLocalStorageInGBs() {
        return this.availableLocalStorageInGBs;
    }

    public String getComputeModel() {
        return this.computeModel;
    }

    public HardwareType getHardwareType() {
        return this.hardwareType;
    }

    public String getDescriptionSummary() {
        return this.descriptionSummary;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FlexComponentSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", minimumCoreCount=").append(String.valueOf(this.minimumCoreCount));
        sb.append(", availableCoreCount=").append(String.valueOf(this.availableCoreCount));
        sb.append(", availableDbStorageInGBs=").append(String.valueOf(this.availableDbStorageInGBs));
        sb.append(", runtimeMinimumCoreCount=").append(String.valueOf(this.runtimeMinimumCoreCount));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", availableMemoryInGBs=").append(String.valueOf(this.availableMemoryInGBs));
        sb.append(", availableLocalStorageInGBs=").append(String.valueOf(this.availableLocalStorageInGBs));
        sb.append(", computeModel=").append(String.valueOf(this.computeModel));
        sb.append(", hardwareType=").append(String.valueOf((Object)this.hardwareType));
        sb.append(", descriptionSummary=").append(String.valueOf(this.descriptionSummary));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlexComponentSummary)) {
            return false;
        }
        FlexComponentSummary other = (FlexComponentSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.minimumCoreCount, other.minimumCoreCount) && Objects.equals(this.availableCoreCount, other.availableCoreCount) && Objects.equals(this.availableDbStorageInGBs, other.availableDbStorageInGBs) && Objects.equals(this.runtimeMinimumCoreCount, other.runtimeMinimumCoreCount) && Objects.equals(this.shape, other.shape) && Objects.equals(this.availableMemoryInGBs, other.availableMemoryInGBs) && Objects.equals(this.availableLocalStorageInGBs, other.availableLocalStorageInGBs) && Objects.equals(this.computeModel, other.computeModel) && Objects.equals((Object)this.hardwareType, (Object)other.hardwareType) && Objects.equals(this.descriptionSummary, other.descriptionSummary) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.minimumCoreCount == null ? 43 : this.minimumCoreCount.hashCode());
        result = result * 59 + (this.availableCoreCount == null ? 43 : this.availableCoreCount.hashCode());
        result = result * 59 + (this.availableDbStorageInGBs == null ? 43 : this.availableDbStorageInGBs.hashCode());
        result = result * 59 + (this.runtimeMinimumCoreCount == null ? 43 : this.runtimeMinimumCoreCount.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.availableMemoryInGBs == null ? 43 : this.availableMemoryInGBs.hashCode());
        result = result * 59 + (this.availableLocalStorageInGBs == null ? 43 : this.availableLocalStorageInGBs.hashCode());
        result = result * 59 + (this.computeModel == null ? 43 : this.computeModel.hashCode());
        result = result * 59 + (this.hardwareType == null ? 43 : this.hardwareType.hashCode());
        result = result * 59 + (this.descriptionSummary == null ? 43 : this.descriptionSummary.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum HardwareType implements BmcEnum
    {
        Compute("COMPUTE"),
        Cell("CELL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, HardwareType> map;

        private HardwareType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static HardwareType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'HardwareType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(HardwareType.class);
            map = new HashMap<String, HardwareType>();
            for (HardwareType v : HardwareType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="minimumCoreCount")
        private Integer minimumCoreCount;
        @JsonProperty(value="availableCoreCount")
        private Integer availableCoreCount;
        @JsonProperty(value="availableDbStorageInGBs")
        private Integer availableDbStorageInGBs;
        @JsonProperty(value="runtimeMinimumCoreCount")
        private Integer runtimeMinimumCoreCount;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="availableMemoryInGBs")
        private Integer availableMemoryInGBs;
        @JsonProperty(value="availableLocalStorageInGBs")
        private Integer availableLocalStorageInGBs;
        @JsonProperty(value="computeModel")
        private String computeModel;
        @JsonProperty(value="hardwareType")
        private HardwareType hardwareType;
        @JsonProperty(value="descriptionSummary")
        private String descriptionSummary;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder minimumCoreCount(Integer minimumCoreCount) {
            this.minimumCoreCount = minimumCoreCount;
            this.__explicitlySet__.add("minimumCoreCount");
            return this;
        }

        public Builder availableCoreCount(Integer availableCoreCount) {
            this.availableCoreCount = availableCoreCount;
            this.__explicitlySet__.add("availableCoreCount");
            return this;
        }

        public Builder availableDbStorageInGBs(Integer availableDbStorageInGBs) {
            this.availableDbStorageInGBs = availableDbStorageInGBs;
            this.__explicitlySet__.add("availableDbStorageInGBs");
            return this;
        }

        public Builder runtimeMinimumCoreCount(Integer runtimeMinimumCoreCount) {
            this.runtimeMinimumCoreCount = runtimeMinimumCoreCount;
            this.__explicitlySet__.add("runtimeMinimumCoreCount");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder availableMemoryInGBs(Integer availableMemoryInGBs) {
            this.availableMemoryInGBs = availableMemoryInGBs;
            this.__explicitlySet__.add("availableMemoryInGBs");
            return this;
        }

        public Builder availableLocalStorageInGBs(Integer availableLocalStorageInGBs) {
            this.availableLocalStorageInGBs = availableLocalStorageInGBs;
            this.__explicitlySet__.add("availableLocalStorageInGBs");
            return this;
        }

        public Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            this.__explicitlySet__.add("computeModel");
            return this;
        }

        public Builder hardwareType(HardwareType hardwareType) {
            this.hardwareType = hardwareType;
            this.__explicitlySet__.add("hardwareType");
            return this;
        }

        public Builder descriptionSummary(String descriptionSummary) {
            this.descriptionSummary = descriptionSummary;
            this.__explicitlySet__.add("descriptionSummary");
            return this;
        }

        public FlexComponentSummary build() {
            FlexComponentSummary model = new FlexComponentSummary(this.name, this.minimumCoreCount, this.availableCoreCount, this.availableDbStorageInGBs, this.runtimeMinimumCoreCount, this.shape, this.availableMemoryInGBs, this.availableLocalStorageInGBs, this.computeModel, this.hardwareType, this.descriptionSummary);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FlexComponentSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("minimumCoreCount")) {
                this.minimumCoreCount(model.getMinimumCoreCount());
            }
            if (model.wasPropertyExplicitlySet("availableCoreCount")) {
                this.availableCoreCount(model.getAvailableCoreCount());
            }
            if (model.wasPropertyExplicitlySet("availableDbStorageInGBs")) {
                this.availableDbStorageInGBs(model.getAvailableDbStorageInGBs());
            }
            if (model.wasPropertyExplicitlySet("runtimeMinimumCoreCount")) {
                this.runtimeMinimumCoreCount(model.getRuntimeMinimumCoreCount());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("availableMemoryInGBs")) {
                this.availableMemoryInGBs(model.getAvailableMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("availableLocalStorageInGBs")) {
                this.availableLocalStorageInGBs(model.getAvailableLocalStorageInGBs());
            }
            if (model.wasPropertyExplicitlySet("computeModel")) {
                this.computeModel(model.getComputeModel());
            }
            if (model.wasPropertyExplicitlySet("hardwareType")) {
                this.hardwareType(model.getHardwareType());
            }
            if (model.wasPropertyExplicitlySet("descriptionSummary")) {
                this.descriptionSummary(model.getDescriptionSummary());
            }
            return this;
        }
    }
}

