/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.ExecutionActionMember;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExecutionAction
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="executionWindowId")
    private final String executionWindowId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleSubstate")
    private final LifecycleSubstate lifecycleSubstate;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="estimatedTimeInMins")
    private final Integer estimatedTimeInMins;
    @JsonProperty(value="totalTimeTakenInMins")
    private final Integer totalTimeTakenInMins;
    @JsonProperty(value="executionActionOrder")
    private final Integer executionActionOrder;
    @JsonProperty(value="actionType")
    private final ActionType actionType;
    @JsonProperty(value="actionParams")
    private final Map<String, String> actionParams;
    @JsonProperty(value="actionMembers")
    private final List<ExecutionActionMember> actionMembers;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "executionWindowId", "compartmentId", "displayName", "description", "lifecycleState", "lifecycleSubstate", "lifecycleDetails", "timeCreated", "timeUpdated", "estimatedTimeInMins", "totalTimeTakenInMins", "executionActionOrder", "actionType", "actionParams", "actionMembers", "freeformTags", "definedTags"})
    public ExecutionAction(String id, String executionWindowId, String compartmentId, String displayName, String description, LifecycleState lifecycleState, LifecycleSubstate lifecycleSubstate, String lifecycleDetails, Date timeCreated, Date timeUpdated, Integer estimatedTimeInMins, Integer totalTimeTakenInMins, Integer executionActionOrder, ActionType actionType, Map<String, String> actionParams, List<ExecutionActionMember> actionMembers, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.executionWindowId = executionWindowId;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.lifecycleState = lifecycleState;
        this.lifecycleSubstate = lifecycleSubstate;
        this.lifecycleDetails = lifecycleDetails;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.estimatedTimeInMins = estimatedTimeInMins;
        this.totalTimeTakenInMins = totalTimeTakenInMins;
        this.executionActionOrder = executionActionOrder;
        this.actionType = actionType;
        this.actionParams = actionParams;
        this.actionMembers = actionMembers;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getExecutionWindowId() {
        return this.executionWindowId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public LifecycleSubstate getLifecycleSubstate() {
        return this.lifecycleSubstate;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Integer getEstimatedTimeInMins() {
        return this.estimatedTimeInMins;
    }

    public Integer getTotalTimeTakenInMins() {
        return this.totalTimeTakenInMins;
    }

    public Integer getExecutionActionOrder() {
        return this.executionActionOrder;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public Map<String, String> getActionParams() {
        return this.actionParams;
    }

    public List<ExecutionActionMember> getActionMembers() {
        return this.actionMembers;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExecutionAction(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", executionWindowId=").append(String.valueOf(this.executionWindowId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleSubstate=").append(String.valueOf((Object)this.lifecycleSubstate));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", estimatedTimeInMins=").append(String.valueOf(this.estimatedTimeInMins));
        sb.append(", totalTimeTakenInMins=").append(String.valueOf(this.totalTimeTakenInMins));
        sb.append(", executionActionOrder=").append(String.valueOf(this.executionActionOrder));
        sb.append(", actionType=").append(String.valueOf((Object)this.actionType));
        sb.append(", actionParams=").append(String.valueOf(this.actionParams));
        sb.append(", actionMembers=").append(String.valueOf(this.actionMembers));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecutionAction)) {
            return false;
        }
        ExecutionAction other = (ExecutionAction)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.executionWindowId, other.executionWindowId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.lifecycleSubstate, (Object)other.lifecycleSubstate) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.estimatedTimeInMins, other.estimatedTimeInMins) && Objects.equals(this.totalTimeTakenInMins, other.totalTimeTakenInMins) && Objects.equals(this.executionActionOrder, other.executionActionOrder) && Objects.equals((Object)this.actionType, (Object)other.actionType) && Objects.equals(this.actionParams, other.actionParams) && Objects.equals(this.actionMembers, other.actionMembers) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.executionWindowId == null ? 43 : this.executionWindowId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleSubstate == null ? 43 : this.lifecycleSubstate.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.estimatedTimeInMins == null ? 43 : this.estimatedTimeInMins.hashCode());
        result = result * 59 + (this.totalTimeTakenInMins == null ? 43 : this.totalTimeTakenInMins.hashCode());
        result = result * 59 + (this.executionActionOrder == null ? 43 : this.executionActionOrder.hashCode());
        result = result * 59 + (this.actionType == null ? 43 : this.actionType.hashCode());
        result = result * 59 + (this.actionParams == null ? 43 : this.actionParams.hashCode());
        result = result * 59 + (this.actionMembers == null ? 43 : this.actionMembers.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Scheduled("SCHEDULED"),
        InProgress("IN_PROGRESS"),
        Failed("FAILED"),
        Canceled("CANCELED"),
        Updating("UPDATING"),
        Deleted("DELETED"),
        Succeeded("SUCCEEDED"),
        PartialSuccess("PARTIAL_SUCCESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleSubstate implements BmcEnum
    {
        DurationExceeded("DURATION_EXCEEDED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        Waiting("WAITING"),
        Rescheduled("RESCHEDULED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleSubstate> map;

        private LifecycleSubstate(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleSubstate create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleSubstate', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleSubstate.class);
            map = new HashMap<String, LifecycleSubstate>();
            for (LifecycleSubstate v : LifecycleSubstate.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ActionType implements BmcEnum
    {
        DbServerFullSoftwareUpdate("DB_SERVER_FULL_SOFTWARE_UPDATE"),
        StorageServerFullSoftwareUpdate("STORAGE_SERVER_FULL_SOFTWARE_UPDATE"),
        NetworkSwitchFullSoftwareUpdate("NETWORK_SWITCH_FULL_SOFTWARE_UPDATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActionType> map;

        private ActionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActionType.class);
            map = new HashMap<String, ActionType>();
            for (ActionType v : ActionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="executionWindowId")
        private String executionWindowId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleSubstate")
        private LifecycleSubstate lifecycleSubstate;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="estimatedTimeInMins")
        private Integer estimatedTimeInMins;
        @JsonProperty(value="totalTimeTakenInMins")
        private Integer totalTimeTakenInMins;
        @JsonProperty(value="executionActionOrder")
        private Integer executionActionOrder;
        @JsonProperty(value="actionType")
        private ActionType actionType;
        @JsonProperty(value="actionParams")
        private Map<String, String> actionParams;
        @JsonProperty(value="actionMembers")
        private List<ExecutionActionMember> actionMembers;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder executionWindowId(String executionWindowId) {
            this.executionWindowId = executionWindowId;
            this.__explicitlySet__.add("executionWindowId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleSubstate(LifecycleSubstate lifecycleSubstate) {
            this.lifecycleSubstate = lifecycleSubstate;
            this.__explicitlySet__.add("lifecycleSubstate");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder estimatedTimeInMins(Integer estimatedTimeInMins) {
            this.estimatedTimeInMins = estimatedTimeInMins;
            this.__explicitlySet__.add("estimatedTimeInMins");
            return this;
        }

        public Builder totalTimeTakenInMins(Integer totalTimeTakenInMins) {
            this.totalTimeTakenInMins = totalTimeTakenInMins;
            this.__explicitlySet__.add("totalTimeTakenInMins");
            return this;
        }

        public Builder executionActionOrder(Integer executionActionOrder) {
            this.executionActionOrder = executionActionOrder;
            this.__explicitlySet__.add("executionActionOrder");
            return this;
        }

        public Builder actionType(ActionType actionType) {
            this.actionType = actionType;
            this.__explicitlySet__.add("actionType");
            return this;
        }

        public Builder actionParams(Map<String, String> actionParams) {
            this.actionParams = actionParams;
            this.__explicitlySet__.add("actionParams");
            return this;
        }

        public Builder actionMembers(List<ExecutionActionMember> actionMembers) {
            this.actionMembers = actionMembers;
            this.__explicitlySet__.add("actionMembers");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public ExecutionAction build() {
            ExecutionAction model = new ExecutionAction(this.id, this.executionWindowId, this.compartmentId, this.displayName, this.description, this.lifecycleState, this.lifecycleSubstate, this.lifecycleDetails, this.timeCreated, this.timeUpdated, this.estimatedTimeInMins, this.totalTimeTakenInMins, this.executionActionOrder, this.actionType, this.actionParams, this.actionMembers, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExecutionAction model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("executionWindowId")) {
                this.executionWindowId(model.getExecutionWindowId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleSubstate")) {
                this.lifecycleSubstate(model.getLifecycleSubstate());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("estimatedTimeInMins")) {
                this.estimatedTimeInMins(model.getEstimatedTimeInMins());
            }
            if (model.wasPropertyExplicitlySet("totalTimeTakenInMins")) {
                this.totalTimeTakenInMins(model.getTotalTimeTakenInMins());
            }
            if (model.wasPropertyExplicitlySet("executionActionOrder")) {
                this.executionActionOrder(model.getExecutionActionOrder());
            }
            if (model.wasPropertyExplicitlySet("actionType")) {
                this.actionType(model.getActionType());
            }
            if (model.wasPropertyExplicitlySet("actionParams")) {
                this.actionParams(model.getActionParams());
            }
            if (model.wasPropertyExplicitlySet("actionMembers")) {
                this.actionMembers(model.getActionMembers());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

