/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbHomeFromAgentResourceId
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="lastPatchHistoryEntryId")
    private final String lastPatchHistoryEntryId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="vmClusterId")
    private final String vmClusterId;
    @JsonProperty(value="dbVersion")
    private final String dbVersion;
    @JsonProperty(value="dbHomeLocation")
    private final String dbHomeLocation;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="oneOffPatches")
    private final List<String> oneOffPatches;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="databaseSoftwareImageId")
    private final String databaseSoftwareImageId;
    @JsonProperty(value="isUnifiedAuditingEnabled")
    private final Boolean isUnifiedAuditingEnabled;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "lastPatchHistoryEntryId", "lifecycleState", "dbSystemId", "vmClusterId", "dbVersion", "dbHomeLocation", "lifecycleDetails", "timeCreated", "kmsKeyId", "oneOffPatches", "freeformTags", "definedTags", "databaseSoftwareImageId", "isUnifiedAuditingEnabled"})
    public DbHomeFromAgentResourceId(String id, String compartmentId, String displayName, String lastPatchHistoryEntryId, LifecycleState lifecycleState, String dbSystemId, String vmClusterId, String dbVersion, String dbHomeLocation, String lifecycleDetails, Date timeCreated, String kmsKeyId, List<String> oneOffPatches, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String databaseSoftwareImageId, Boolean isUnifiedAuditingEnabled) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.lastPatchHistoryEntryId = lastPatchHistoryEntryId;
        this.lifecycleState = lifecycleState;
        this.dbSystemId = dbSystemId;
        this.vmClusterId = vmClusterId;
        this.dbVersion = dbVersion;
        this.dbHomeLocation = dbHomeLocation;
        this.lifecycleDetails = lifecycleDetails;
        this.timeCreated = timeCreated;
        this.kmsKeyId = kmsKeyId;
        this.oneOffPatches = oneOffPatches;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.databaseSoftwareImageId = databaseSoftwareImageId;
        this.isUnifiedAuditingEnabled = isUnifiedAuditingEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLastPatchHistoryEntryId() {
        return this.lastPatchHistoryEntryId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public String getDbHomeLocation() {
        return this.dbHomeLocation;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public List<String> getOneOffPatches() {
        return this.oneOffPatches;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDatabaseSoftwareImageId() {
        return this.databaseSoftwareImageId;
    }

    public Boolean getIsUnifiedAuditingEnabled() {
        return this.isUnifiedAuditingEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbHomeFromAgentResourceId(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", lastPatchHistoryEntryId=").append(String.valueOf(this.lastPatchHistoryEntryId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(", vmClusterId=").append(String.valueOf(this.vmClusterId));
        sb.append(", dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(", dbHomeLocation=").append(String.valueOf(this.dbHomeLocation));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", oneOffPatches=").append(String.valueOf(this.oneOffPatches));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", databaseSoftwareImageId=").append(String.valueOf(this.databaseSoftwareImageId));
        sb.append(", isUnifiedAuditingEnabled=").append(String.valueOf(this.isUnifiedAuditingEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbHomeFromAgentResourceId)) {
            return false;
        }
        DbHomeFromAgentResourceId other = (DbHomeFromAgentResourceId)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.lastPatchHistoryEntryId, other.lastPatchHistoryEntryId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.vmClusterId, other.vmClusterId) && Objects.equals(this.dbVersion, other.dbVersion) && Objects.equals(this.dbHomeLocation, other.dbHomeLocation) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.oneOffPatches, other.oneOffPatches) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.databaseSoftwareImageId, other.databaseSoftwareImageId) && Objects.equals(this.isUnifiedAuditingEnabled, other.isUnifiedAuditingEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lastPatchHistoryEntryId == null ? 43 : this.lastPatchHistoryEntryId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.vmClusterId == null ? 43 : this.vmClusterId.hashCode());
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        result = result * 59 + (this.dbHomeLocation == null ? 43 : this.dbHomeLocation.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.oneOffPatches == null ? 43 : this.oneOffPatches.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.databaseSoftwareImageId == null ? 43 : this.databaseSoftwareImageId.hashCode());
        result = result * 59 + (this.isUnifiedAuditingEnabled == null ? 43 : this.isUnifiedAuditingEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lastPatchHistoryEntryId")
        private String lastPatchHistoryEntryId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="vmClusterId")
        private String vmClusterId;
        @JsonProperty(value="dbVersion")
        private String dbVersion;
        @JsonProperty(value="dbHomeLocation")
        private String dbHomeLocation;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="oneOffPatches")
        private List<String> oneOffPatches;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="databaseSoftwareImageId")
        private String databaseSoftwareImageId;
        @JsonProperty(value="isUnifiedAuditingEnabled")
        private Boolean isUnifiedAuditingEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lastPatchHistoryEntryId(String lastPatchHistoryEntryId) {
            this.lastPatchHistoryEntryId = lastPatchHistoryEntryId;
            this.__explicitlySet__.add("lastPatchHistoryEntryId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            this.__explicitlySet__.add("vmClusterId");
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            this.__explicitlySet__.add("dbVersion");
            return this;
        }

        public Builder dbHomeLocation(String dbHomeLocation) {
            this.dbHomeLocation = dbHomeLocation;
            this.__explicitlySet__.add("dbHomeLocation");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder oneOffPatches(List<String> oneOffPatches) {
            this.oneOffPatches = oneOffPatches;
            this.__explicitlySet__.add("oneOffPatches");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder databaseSoftwareImageId(String databaseSoftwareImageId) {
            this.databaseSoftwareImageId = databaseSoftwareImageId;
            this.__explicitlySet__.add("databaseSoftwareImageId");
            return this;
        }

        public Builder isUnifiedAuditingEnabled(Boolean isUnifiedAuditingEnabled) {
            this.isUnifiedAuditingEnabled = isUnifiedAuditingEnabled;
            this.__explicitlySet__.add("isUnifiedAuditingEnabled");
            return this;
        }

        public DbHomeFromAgentResourceId build() {
            DbHomeFromAgentResourceId model = new DbHomeFromAgentResourceId(this.id, this.compartmentId, this.displayName, this.lastPatchHistoryEntryId, this.lifecycleState, this.dbSystemId, this.vmClusterId, this.dbVersion, this.dbHomeLocation, this.lifecycleDetails, this.timeCreated, this.kmsKeyId, this.oneOffPatches, this.freeformTags, this.definedTags, this.databaseSoftwareImageId, this.isUnifiedAuditingEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbHomeFromAgentResourceId model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lastPatchHistoryEntryId")) {
                this.lastPatchHistoryEntryId(model.getLastPatchHistoryEntryId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("dbSystemId")) {
                this.dbSystemId(model.getDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("vmClusterId")) {
                this.vmClusterId(model.getVmClusterId());
            }
            if (model.wasPropertyExplicitlySet("dbVersion")) {
                this.dbVersion(model.getDbVersion());
            }
            if (model.wasPropertyExplicitlySet("dbHomeLocation")) {
                this.dbHomeLocation(model.getDbHomeLocation());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("oneOffPatches")) {
                this.oneOffPatches(model.getOneOffPatches());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("databaseSoftwareImageId")) {
                this.databaseSoftwareImageId(model.getDatabaseSoftwareImageId());
            }
            if (model.wasPropertyExplicitlySet("isUnifiedAuditingEnabled")) {
                this.isUnifiedAuditingEnabled(model.getIsUnifiedAuditingEnabled());
            }
            return this;
        }
    }
}

