/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.util.function.Function;

public final class InterpolationHelper {
    private static final char ESCAPE_CHAR = '\\';
    private static final String DELIM_START = "@{";
    private static final String DELIM_STOP = "}";
    private static final String MARKER = "@__";

    private InterpolationHelper() {
    }

    public static String substVars(String val, Function<String, String> callback, boolean defaultsToEmptyString) throws IllegalArgumentException {
        return InterpolationHelper.unescape(InterpolationHelper.doSubstVars(val, callback, defaultsToEmptyString));
    }

    private static String doSubstVars(String val, Function<String, String> callback, boolean defaultsToEmptyString) throws IllegalArgumentException {
        int startDelim;
        int stopDelim = -1;
        do {
            int idx;
            stopDelim = ((String)val).indexOf(DELIM_STOP, stopDelim + 1);
            while (stopDelim > 0 && ((String)val).charAt(stopDelim - 1) == '\\') {
                stopDelim = ((String)val).indexOf(DELIM_STOP, stopDelim + 1);
            }
            startDelim = ((String)val).indexOf(DELIM_START);
            while (stopDelim >= 0 && (idx = ((String)val).indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
                if (idx >= stopDelim) continue;
                startDelim = idx;
            }
        } while (startDelim >= 0 && stopDelim >= 0 && stopDelim < startDelim + DELIM_START.length());
        if (startDelim < 0 || stopDelim < 0) {
            return val;
        }
        String variable = ((String)val).substring(startDelim + DELIM_START.length(), stopDelim);
        Object substValue = null;
        if (variable.length() > 0 && callback != null) {
            substValue = callback.apply(variable);
        }
        if (substValue == null) {
            substValue = defaultsToEmptyString ? "" : "@__{" + variable + DELIM_STOP;
        }
        val = ((String)val).substring(0, startDelim) + (String)substValue + ((String)val).substring(stopDelim + DELIM_STOP.length());
        val = InterpolationHelper.doSubstVars((String)val, callback, defaultsToEmptyString);
        return val;
    }

    private static String unescape(String val) {
        val = ((String)val).replaceAll(MARKER, "@");
        int escape = ((String)val).indexOf(92);
        while (escape >= 0 && escape < ((String)val).length() - 1) {
            char c = ((String)val).charAt(escape + 1);
            if (c == '{' || c == '}' || c == '\\') {
                val = ((String)val).substring(0, escape) + ((String)val).substring(escape + 1);
            }
            escape = ((String)val).indexOf(92, escape + 1);
        }
        return val;
    }
}

