/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import jakarta.json.JsonException;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.parser.IndexColumn;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.PathParser;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class IndexSpecification {
    private final InputStream source;
    private final JsonParserFactory factory;
    private boolean is_parsed = false;
    private String idxName = null;
    private String language = null;
    private IndexColumn[] columns = new IndexColumn[0];
    private boolean is_unique = false;
    private boolean is_scalarRequired = false;
    private boolean is_lax = false;
    private JsonQueryPath spatial = null;
    private String search_on = null;
    private boolean is_121_text_index_with_lang = false;
    private String dataguide = null;
    private boolean indexNulls = false;
    private boolean force = false;
    private BigDecimal ttl = null;
    private boolean multivalue = false;

    public IndexSpecification(JsonFactoryProvider jsonFactoryProvider, InputStream inputStream) {
        this.factory = jsonFactoryProvider.getParserFactory();
        this.source = inputStream;
    }

    private void makeAndThrowException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        QueryException.throwSyntaxException(queryMessage, objectArray);
    }

    private void close() throws QueryException {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), iOException);
        }
    }

    private String eventToString(JsonParser.Event event) {
        switch (event) {
            case START_OBJECT: 
            case END_OBJECT: {
                return "OBJECT";
            }
            case START_ARRAY: 
            case END_ARRAY: {
                return "ARRAY";
            }
            case VALUE_TRUE: {
                return "TRUE";
            }
            case VALUE_FALSE: {
                return "FALSE";
            }
            case VALUE_NULL: {
                return "NULL";
            }
            case VALUE_STRING: {
                return "STRING";
            }
            case VALUE_NUMBER: {
                return "NUMBER";
            }
            case KEY_NAME: {
                return "KEY";
            }
        }
        return event.toString();
    }

    private String getString(JsonParser jsonParser, String string) throws QueryException {
        JsonParser.Event event;
        if (!jsonParser.hasNext()) {
            this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
        }
        if ((event = jsonParser.next()) != JsonParser.Event.VALUE_STRING) {
            this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, string, "STRING", this.eventToString(event));
        }
        return jsonParser.getString();
    }

    private BigDecimal getNumber(JsonParser jsonParser, String string) throws QueryException {
        JsonParser.Event event;
        if (!jsonParser.hasNext()) {
            this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
        }
        if ((event = jsonParser.next()) != JsonParser.Event.VALUE_NUMBER) {
            this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, string, "NUMBER", this.eventToString(event));
        }
        return jsonParser.getBigDecimal();
    }

    private boolean getBoolean(JsonParser jsonParser, String string) throws QueryException {
        boolean bl = false;
        if (!jsonParser.hasNext()) {
            this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
        }
        JsonParser.Event event = jsonParser.next();
        switch (event) {
            case VALUE_TRUE: {
                bl = true;
                break;
            }
            case VALUE_FALSE: {
                bl = false;
                break;
            }
            default: {
                this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, string, "BOOLEAN", this.eventToString(event));
            }
        }
        return bl;
    }

    private void skipField(JsonParser jsonParser) throws QueryException {
        int n = 0;
        do {
            if (!jsonParser.hasNext()) {
                this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
            }
            JsonParser.Event event = jsonParser.next();
            switch (event) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++n;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    --n;
                    break;
                }
            }
        } while (n > 0);
    }

    private ArrayList<IndexColumn> processFields(JsonParser jsonParser) throws QueryException {
        JsonParser.Event event;
        int n = 0;
        ArrayList<IndexColumn> arrayList = new ArrayList<IndexColumn>();
        if (!jsonParser.hasNext()) {
            this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
        }
        if ((event = jsonParser.next()) != JsonParser.Event.START_ARRAY) {
            this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields", "ARRAY", this.eventToString(event));
        }
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        boolean bl3 = false;
        while (jsonParser.hasNext()) {
            event = jsonParser.next();
            block1 : switch (event) {
                case END_ARRAY: {
                    bl = true;
                    break;
                }
                case START_OBJECT: {
                    if (bl2) {
                        this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
                    }
                    bl2 = true;
                    string = null;
                    string2 = null;
                    string3 = null;
                    n2 = 0;
                    bl3 = false;
                    break;
                }
                case END_OBJECT: {
                    if (!bl2) {
                        this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
                    }
                    bl2 = false;
                    if (string == null) {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_MISSING, "fields.path");
                    }
                    IndexColumn indexColumn = new IndexColumn();
                    PathParser pathParser = new PathParser(string);
                    String[] stringArray = pathParser.splitAndSQLEscape();
                    if (stringArray == null) {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_ILLEGAL_PATH, string);
                    }
                    indexColumn.setPath(stringArray);
                    if (string2 != null) {
                        int n3 = indexColumn.setSqlType(string2);
                        if (n3 == 0) {
                            this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_DTYPE, string2);
                        } else if (n3 != 1 && bl3) {
                            this.makeAndThrowException(QueryMessage.EX_LENGTH_NOT_ALLOWED, string);
                        }
                    }
                    if (n2 > 0) {
                        indexColumn.setMaxLength(n2);
                    } else if (n2 < 0) {
                        this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_DLEN, Integer.toString(n2));
                    }
                    indexColumn.setOrder(string3);
                    arrayList.add(indexColumn);
                    ++n;
                    break;
                }
                case KEY_NAME: {
                    String string4;
                    if (!bl2) {
                        this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
                    }
                    if ((string4 = jsonParser.getString()).equalsIgnoreCase("path")) {
                        string = this.getString(jsonParser, "fields.path");
                        break;
                    }
                    if (string4.equalsIgnoreCase("datatype")) {
                        string2 = this.getString(jsonParser, "fields.datatype");
                        break;
                    }
                    if (string4.equalsIgnoreCase("order")) {
                        event = jsonParser.next();
                        switch (event) {
                            case VALUE_STRING: {
                                string3 = jsonParser.getString();
                                if (string3.equalsIgnoreCase("asc") || string3.equalsIgnoreCase("desc") || string3.equals("1") || string3.equals("-1")) break block1;
                                this.makeAndThrowException(QueryMessage.EX_WRONG_ORDER, string3);
                                break;
                            }
                            case VALUE_NUMBER: {
                                string3 = jsonParser.getBigDecimal().toString();
                                if (string3.equals("-1") || string3.equals("1")) break block1;
                                this.makeAndThrowException(QueryMessage.EX_WRONG_ORDER, string3);
                                break;
                            }
                            default: {
                                this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.order", "STRING", this.eventToString(event));
                                break;
                            }
                        }
                        break;
                    }
                    if (string4.equalsIgnoreCase("maxLength")) {
                        bl3 = true;
                        BigDecimal bigDecimal = this.getNumber(jsonParser, "fields.maxLength");
                        try {
                            n2 = bigDecimal.intValueExact();
                        }
                        catch (ArithmeticException arithmeticException) {
                            this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.maxLength", "integer", "decimal");
                        }
                        break;
                    }
                    this.skipField(jsonParser);
                    break;
                }
                default: {
                    this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields", "OBJECT", this.eventToString(event));
                }
            }
            if (!bl) continue;
        }
        if (bl2) {
            this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
        }
        if (n == 0) {
            this.makeAndThrowException(QueryMessage.EX_FIELDS_CANNOT_BE_EMPTY, new Object[0]);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public String parse(boolean bl, boolean bl2) throws QueryException {
        JsonParser jsonParser = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        QueryException queryException = null;
        try {
            void var10_11;
            int n;
            if (this.source == null) {
                this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
            }
            jsonParser = this.factory.createParser(this.source);
            Object object = null;
            while (jsonParser.hasNext()) {
                JsonParser.Event event = jsonParser.next();
                switch (event) {
                    case START_OBJECT: 
                    case END_OBJECT: {
                        break;
                    }
                    case START_ARRAY: 
                    case END_ARRAY: {
                        this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
                    }
                    case KEY_NAME: {
                        String string = jsonParser.getString();
                        if (string.equalsIgnoreCase("name")) {
                            this.idxName = this.getString(jsonParser, "index name");
                            break;
                        }
                        if (string.equalsIgnoreCase("unique")) {
                            this.is_unique = this.getBoolean(jsonParser, "unique");
                            bl3 = true;
                            break;
                        }
                        if (string.equalsIgnoreCase("scalarRequired")) {
                            this.is_scalarRequired = this.getBoolean(jsonParser, "scalarRequired");
                            if (this.is_lax && this.is_scalarRequired) {
                                this.makeAndThrowException(QueryMessage.EX_SCALAR_AND_LAX, new Object[0]);
                            }
                            bl4 = true;
                            break;
                        }
                        if (string.equalsIgnoreCase("lax")) {
                            this.is_lax = this.getBoolean(jsonParser, "lax");
                            if (this.is_lax && this.is_scalarRequired) {
                                this.makeAndThrowException(QueryMessage.EX_SCALAR_AND_LAX, new Object[0]);
                            }
                            bl5 = true;
                            break;
                        }
                        if (string.equalsIgnoreCase("indexNulls")) {
                            this.indexNulls = this.getBoolean(jsonParser, "indexNulls");
                            bl6 = true;
                            break;
                        }
                        if (string.equalsIgnoreCase("force") && bl2) {
                            this.force = this.getBoolean(jsonParser, "force");
                            break;
                        }
                        if (string.equalsIgnoreCase("spatial")) {
                            this.spatial = new JsonQueryPath(this.getString(jsonParser, "spatial"));
                            break;
                        }
                        if (string.equalsIgnoreCase("language")) {
                            this.language = this.getString(jsonParser, "language");
                            break;
                        }
                        if (string.equalsIgnoreCase("dataguide")) {
                            this.dataguide = this.getString(jsonParser, "dataguide");
                            if (this.dataguide.equalsIgnoreCase("on") || this.dataguide.equalsIgnoreCase("off")) break;
                            this.makeAndThrowException(QueryMessage.EX_BAD_DATAGUIDE_VALUE, this.dataguide);
                            break;
                        }
                        if (string.equalsIgnoreCase("search_on")) {
                            this.search_on = this.getString(jsonParser, "search_on");
                            if (this.search_on.equalsIgnoreCase("text") || this.search_on.equalsIgnoreCase("text_value") || this.search_on.equalsIgnoreCase("none")) break;
                            this.makeAndThrowException(QueryMessage.EX_BAD_SEARCH_ON_VALUE, this.search_on);
                            break;
                        }
                        if (string.equalsIgnoreCase("textIndex121WithLang")) {
                            this.is_121_text_index_with_lang = this.getBoolean(jsonParser, "textIndex121WithLang");
                            break;
                        }
                        if (string.equalsIgnoreCase("fields")) {
                            ArrayList<IndexColumn> arrayList = this.processFields(jsonParser);
                            break;
                        }
                        if (string.equalsIgnoreCase("ttl")) {
                            this.ttl = this.getNumber(jsonParser, "ttl");
                            break;
                        }
                        if (string.equalsIgnoreCase("multivalue")) {
                            this.multivalue = this.getBoolean(jsonParser, "multivalue");
                            bl7 = true;
                            break;
                        }
                        this.skipField(jsonParser);
                    }
                }
            }
            int n2 = n = var10_11 == null ? 0 : var10_11.size();
            if (n > 0) {
                if (this.language != null) {
                    this.makeAndThrowException(QueryMessage.EX_LANGUAGE_NOT_EXPECTED, new Object[0]);
                }
                this.columns = new IndexColumn[n];
                this.columns = var10_11.toArray(this.columns);
            } else if (n == 0) {
                if (bl3) {
                    this.makeAndThrowException(QueryMessage.EX_FIELDS_REQUIRED, "unique");
                }
                if (bl6) {
                    this.makeAndThrowException(QueryMessage.EX_FIELDS_REQUIRED, "indexNulls");
                }
                if (bl7) {
                    this.makeAndThrowException(QueryMessage.EX_FIELDS_REQUIRED, "multivalue");
                }
                if (this.spatial == null) {
                    if (bl4) {
                        this.makeAndThrowException(QueryMessage.EX_FIELDS_OR_SPATIAL_REQUIRED, "scalarRequired");
                    } else if (bl5) {
                        this.makeAndThrowException(QueryMessage.EX_FIELDS_OR_SPATIAL_REQUIRED, "lax");
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), illegalArgumentException);
        }
        catch (JsonException jsonException) {
            throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), (Exception)((Object)jsonException));
        }
        finally {
            try {
                if (jsonParser != null) {
                    jsonParser.close();
                }
                this.close();
            }
            catch (JsonException jsonException) {
                queryException = new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), (Exception)((Object)jsonException));
            }
            catch (QueryException queryException2) {
                queryException = queryException2;
            }
        }
        if (queryException != null) {
            throw queryException;
        }
        if (this.columns.length > 0) {
            if (this.spatial != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "fields", "spatial");
            }
            if (this.language != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "fields", "language");
            }
            if (this.search_on != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "fields", "search_on");
            }
            if (this.dataguide != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "fields", "dataguide");
            }
            if (this.is_121_text_index_with_lang) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "fields", "textIndex121WithLang");
            }
        } else if (this.spatial != null) {
            if (this.language != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "spatial", "language");
            }
            if (this.search_on != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "spatial", "search_on");
            }
            if (this.dataguide != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "spatial", "dataguide");
            }
            if (this.is_121_text_index_with_lang) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "spatial", "textIndex121WithLang");
            }
            if (this.ttl != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "spatial", "ttl");
            }
            if (bl7) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "spatial", "multivalue");
            }
        } else if (this.search_on != null) {
            if (this.is_121_text_index_with_lang) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "search_on", "textIndex121WithLang");
            }
            if (this.ttl != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "search_on", "ttl");
            }
            if (bl7) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "search_on", "multivalue");
            }
        } else if (this.dataguide != null) {
            if (this.is_121_text_index_with_lang) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "dataguide", "textIndex121WithLang");
            }
            if (this.ttl != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "dataguide", "ttl");
            }
            if (bl7) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "dataguide", "multivalue");
            }
        }
        if (bl7) {
            if (this.is_121_text_index_with_lang) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "multivalue", "textIndex121WithLang");
            }
            if (this.ttl != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "multivalue", "ttl");
            }
            if (this.language != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "multivalue", "language");
            }
            if (bl5) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "multivalue", "lax");
            }
            if (bl4) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "multivalue", "scalarRequired");
            }
            if (bl6) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "multivalue", "indexNulls");
            }
            for (IndexColumn indexColumn : this.columns) {
                String string = indexColumn.getSqlTypeName();
                int n = indexColumn.getMaxLength();
                if (string != null) {
                    this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "datatype", "multivalue");
                }
                if (n == 0) continue;
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "maxlength", "multivalue");
            }
        }
        if (bl && this.idxName == null) {
            this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_MISSING, "name");
        }
        this.is_parsed = true;
        return this.idxName;
    }

    public String parse() throws QueryException {
        return this.parse(true, false);
    }

    public String getName() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.idxName;
    }

    public String getLanguage() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.language;
    }

    public boolean isUnique() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.is_unique;
    }

    public JsonQueryPath getSpatialPath() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.spatial;
    }

    public String getSearchOn() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.search_on;
    }

    public String getDataGuide() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.dataguide;
    }

    public BigDecimal getTTL() {
        return this.ttl;
    }

    public boolean getMultiValue() {
        return this.multivalue;
    }

    public boolean isScalarRequired() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.is_scalarRequired;
    }

    public boolean isLax() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.is_lax;
    }

    public boolean indexNulls() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.indexNulls;
    }

    public boolean force() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.force;
    }

    public IndexColumn[] getColumns() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.columns;
    }

    public boolean is121TextIndexWithLang() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.is_121_text_index_with_lang;
    }

    public static String get121Lexer(String string) throws QueryException {
        String string2 = null;
        if (string == null) {
            string2 = "CTXSYS.JSONREST_ENGLISH_LEXER";
        } else if (string.equalsIgnoreCase("english")) {
            string2 = "CTXSYS.JSONREST_ENGLISH_LEXER";
        } else if (string.equalsIgnoreCase("arabic")) {
            string2 = "CTXSYS.JSONREST_ARABIC_LEXER";
        } else if (string.equalsIgnoreCase("nynorsk")) {
            string2 = "CTXSYS.JSONREST_NYNORSK_LEXER";
        } else if (string.equalsIgnoreCase("bokmal")) {
            string2 = "CTXSYS.JSONREST_BOKMAL_LEXER";
        } else if (string.equalsIgnoreCase("persian")) {
            string2 = "CTXSYS.JSONREST_PERSIAN_LEXER";
        } else if (string.equalsIgnoreCase("croatian")) {
            string2 = "CTXSYS.JSONREST_CROATIAN_LEXER";
        } else if (string.equalsIgnoreCase("serbian")) {
            string2 = "CTXSYS.JSONREST_SERBIAN_LEXER";
        } else if (string.equalsIgnoreCase("danish")) {
            string2 = "CTXSYS.JSONREST_DANISH_LEXER";
        } else if (string.equalsIgnoreCase("slovak")) {
            string2 = "CTXSYS.JSONREST_SLOVAK_LEXER";
        } else if (string.equalsIgnoreCase("finnish")) {
            string2 = "CTXSYS.JSONREST_FINNISH_LEXER";
        } else if (string.equalsIgnoreCase("slovenian")) {
            string2 = "CTXSYS.JSONREST_SLOVENIAN_LEXER";
        } else if (string.equalsIgnoreCase("hebrew")) {
            string2 = "CTXSYS.JSONREST_HEBREW_LEXER";
        } else if (string.equalsIgnoreCase("thai")) {
            string2 = "CTXSYS.JSONREST_THAI_LEXER";
        } else if (string.equalsIgnoreCase("catalan")) {
            string2 = "CTXSYS.JSONREST_CATALAN_LEXER";
        } else if (string.equalsIgnoreCase("korean")) {
            string2 = "CTXSYS.JSONREST_KOREAN_LEXER";
        } else if (string.equalsIgnoreCase("czech")) {
            string2 = "CTXSYS.JSONREST_CZECH_LEXER";
        } else if (string.equalsIgnoreCase("polish")) {
            string2 = "CTXSYS.JSONREST_POLISH_LEXER";
        } else if (string.equalsIgnoreCase("dutch")) {
            string2 = "CTXSYS.JSONREST_DUTCH_LEXER";
        } else if (string.equalsIgnoreCase("portuguese")) {
            string2 = "CTXSYS.JSONREST_PORTUGUESE_LEXER";
        } else if (string.equalsIgnoreCase("romanian")) {
            string2 = "CTXSYS.JSONREST_ROMANIAN_LEXER";
        } else if (string.equalsIgnoreCase("french")) {
            string2 = "CTXSYS.JSONREST_FRENCH_LEXER";
        } else if (string.equalsIgnoreCase("russian")) {
            string2 = "CTXSYS.JSONREST_RUSSIAN_LEXER";
        } else if (string.equalsIgnoreCase("german")) {
            string2 = "CTXSYS.JSONREST_GERMAN_LEXER";
        } else if (string.equalsIgnoreCase("simp-chinese")) {
            string2 = "CTXSYS.JSONREST_SCHINESE_LEXER";
        } else if (string.equalsIgnoreCase("trad-chinese")) {
            string2 = "CTXSYS.JSONREST_TCHINESE_LEXER";
        } else if (string.equalsIgnoreCase("greek")) {
            string2 = "CTXSYS.JSONREST_GREEK_LEXER";
        } else if (string.equalsIgnoreCase("spanish")) {
            string2 = "CTXSYS.JSONREST_SPANISH_LEXER";
        } else if (string.equalsIgnoreCase("hungarian")) {
            string2 = "CTXSYS.JSONREST_HUNGARIAN_LEXER";
        } else if (string.equalsIgnoreCase("swedish")) {
            string2 = "CTXSYS.JSONREST_SWEDISH_LEXER";
        } else if (string.equalsIgnoreCase("italian")) {
            string2 = "CTXSYS.JSONREST_ITALIAN_LEXER";
        } else if (string.equalsIgnoreCase("japanese")) {
            string2 = "CTXSYS.JSONREST_JAPANESE_LEXER";
        } else if (string.equalsIgnoreCase("turkish")) {
            string2 = "CTXSYS.JSONREST_TURKISH_LEXER";
        } else {
            QueryException.throwSyntaxException(QueryMessage.EX_INVALID_INDEX_LANG, string);
        }
        return string2;
    }

    public static String getLexer(String string) throws QueryException {
        String string2 = null;
        if (string == null) {
            string2 = null;
        } else if (string.equalsIgnoreCase("english")) {
            string2 = null;
        } else if (string.equalsIgnoreCase("danish")) {
            string2 = "DANISH";
        } else if (string.equalsIgnoreCase("finnish")) {
            string2 = "FINNISH";
        } else if (string.equalsIgnoreCase("dutch")) {
            string2 = "DUTCH";
        } else if (string.equalsIgnoreCase("portuguese")) {
            string2 = "PORTUGUESE";
        } else if (string.equalsIgnoreCase("romanian")) {
            string2 = "ROMANIAN";
        } else if (string.equalsIgnoreCase("german")) {
            string2 = "GERMAN";
        } else if (string.equalsIgnoreCase("simplified_chinese")) {
            string2 = "SIMPLIFIED_CHINESE";
        } else if (string.equalsIgnoreCase("traditional_chinese")) {
            string2 = "TRADITIONAL_CHINESE";
        } else if (string.equalsIgnoreCase("korean")) {
            string2 = "KOREAN";
        } else if (string.equalsIgnoreCase("swedish")) {
            string2 = "SWEDISH";
        } else if (string.equalsIgnoreCase("japanese")) {
            string2 = "JAPANESE";
        } else if (string.equalsIgnoreCase("german_din")) {
            string2 = "GERMAN_DIN";
        } else if (string.equalsIgnoreCase("norwegian")) {
            string2 = "NORWEGIAN";
        } else if (string.equalsIgnoreCase("catalan")) {
            string2 = "CATALAN";
        } else if (string.equalsIgnoreCase("french")) {
            string2 = "FRENCH";
        } else if (string.equalsIgnoreCase("spanish")) {
            string2 = "SPANISH";
        } else if (string.equalsIgnoreCase("italian")) {
            string2 = "ITALIAN";
        } else if (string.equalsIgnoreCase("brazilian_portuguese")) {
            string2 = "BRAZILIAN_PORTUGUESE";
        } else if (string.equalsIgnoreCase("french_canadian")) {
            string2 = "FRENCH_CANADIAN";
        } else if (string.equalsIgnoreCase("latin_american_spanish")) {
            string2 = "LATIN_AMERICAN_SPANISH";
        } else if (string.equalsIgnoreCase("mexican_spanish")) {
            string2 = "MEXICAN_SPANISH";
        } else {
            QueryException.throwSyntaxException(QueryMessage.EX_INVALID_INDEX_LANG, string);
        }
        return string2;
    }
}

