/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.util.List;
import oracle.json.parser.JsonPath;

public class IndexColumn
extends JsonPath {
    public static final int SQLTYPE_NONE = 0;
    public static final int SQLTYPE_CHAR = 1;
    public static final int SQLTYPE_NUMBER = 2;
    public static final int SQLTYPE_DATE = 3;
    public static final int SQLTYPE_TIMESTAMP = 4;
    public static final int SQLTYPE_JSON = 5;
    public static final int KEY_NAME = 1;
    public static final int KEY_UNIQUE = 2;
    public static final int KEY_COLUMNS = 3;
    public static final int MAX_CHAR_COLUMNS = 16;
    public static final String ASC_ORDER = "ASC";
    public static final String DESC_ORDER = "DESC";
    private int sqlType = 0;
    private int maxLength = 0;
    private String order = "ASC";

    public IndexColumn() {
        super((String)null);
    }

    public IndexColumn(String string, boolean bl, String string2) {
        super(string2);
    }

    public IndexColumn(String string, boolean bl, String[] stringArray) {
        super(stringArray);
    }

    public IndexColumn(String string, boolean bl, List<String> list) {
        super(list);
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getOrder() {
        return this.order;
    }

    public String getSqlTypeNameDefault() {
        return "VARCHAR2";
    }

    public String getSqlTypeName() {
        switch (this.sqlType) {
            case 1: {
                return "VARCHAR2";
            }
            case 2: {
                return "NUMBER";
            }
            case 3: {
                return "DATE";
            }
            case 4: {
                return "TIMESTAMP";
            }
            case 5: {
                return "JSON";
            }
        }
        return null;
    }

    public void setSqlType(int n) {
        this.sqlType = n;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public void setOrder(String string) {
        this.order = string != null && (string.equalsIgnoreCase(DESC_ORDER) || string.equalsIgnoreCase("-1")) ? DESC_ORDER : ASC_ORDER;
    }

    public int setSqlType(String string) {
        int n = 0;
        if (string != null) {
            if (string.equalsIgnoreCase("NUMBER")) {
                n = 2;
            } else if (string.equalsIgnoreCase("DATE")) {
                n = 3;
            } else if (string.equalsIgnoreCase("TIMESTAMP")) {
                n = 4;
            } else if (string.equalsIgnoreCase("STRING") || string.equalsIgnoreCase("VARCHAR") || string.equalsIgnoreCase("VARCHAR2")) {
                n = 1;
            } else if (string.equalsIgnoreCase("JSON")) {
                n = 5;
            }
        }
        if (n != 0) {
            this.sqlType = n;
        }
        return n;
    }

    public void setPath(String[] stringArray) {
        this.steps = stringArray;
    }
}

