/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.json.logging.OracleLog;

public class MetricsCollector {
    private static final Logger log = Logger.getLogger(MetricsCollector.class.getName());
    private static final int FINE_LOG_LEVEL = Level.FINE.intValue();
    private static final int currentLogLevel = MetricsCollector.getLogLevel();
    private int dbLobReads = 0;
    private int dbLobWrites = 0;
    private int dbDocReadRoundTrips = 0;
    private int dbDocWriteRoundTrips = 0;
    private int dbCursorReads = 0;
    private int dbTimestampReads = 0;
    private int dbDDLs = 0;
    private int dbGUIDs = 0;
    private int dbProcCalls = 0;
    private int dbSequenceBatch = 0;
    private int checksums = 0;
    private int ioWrites = 0;
    private int ioReadBytes = 0;
    private int ioWriteBytes = 0;
    private long dbLobReadNanos = 0L;
    private long dbLobWriteNanos = 0L;
    private long dbDocReadNanos = 0L;
    private long dbDocWriteNanos = 0L;
    private long dbConnectNanos = 0L;
    private long dbTransactionNanos = 0L;
    private long dbTimestampNanons = 0L;
    private long dbDDLNanos = 0L;
    private long dbGUIDNanos = 0L;
    private long dbProcCallNanos = 0L;
    private long dbSequenceBatchNanos = 0L;
    private long checksumNanos = 0L;
    private long ioReadNanos = 0L;
    private long ioWriteNanos = 0L;
    private long total_time = 0L;
    private long start_time = 0L;
    private StringBuilder formattingBuffer = new StringBuilder(30);
    private boolean encounteredNegativeTimeDiff = false;

    public MetricsCollector() {
        this.reset();
    }

    private void reset() {
        this.total_time = this.getTime();
    }

    public long getTime() {
        return System.nanoTime();
    }

    public long getTimeDiff(long l) {
        long l2 = this.getTime() - l;
        if (l2 < 0L) {
            this.encounteredNegativeTimeDiff = true;
            l2 = 0L;
        }
        return l2;
    }

    public void startTiming() {
        this.start_time = this.getTime();
    }

    public long endTiming() {
        return this.getTimeDiff(this.start_time);
    }

    public void recordTimestampRead() {
        this.dbTimestampNanons += this.endTiming();
        ++this.dbTimestampReads;
    }

    public void recordDDL() {
        ++this.dbDDLs;
        this.dbDDLNanos += this.endTiming();
    }

    public void recordWrites(int n, int n2) {
        int n3 = (n + n2 - 1) / n2;
        this.dbDocWriteNanos += this.endTiming();
        this.dbDocWriteRoundTrips += n3;
    }

    public void recordReads(int n, int n2) {
        int n3 = (n + n2 - 1) / n2;
        this.dbDocReadNanos += this.endTiming();
        this.dbDocReadRoundTrips += n3;
    }

    public void recordGUIDS() {
        this.dbGUIDNanos += this.endTiming();
        ++this.dbGUIDs;
    }

    public void recordCall() {
        this.dbProcCallNanos += this.endTiming();
        ++this.dbProcCalls;
    }

    public void recordsSequenceBatchFetches() {
        this.dbSequenceBatchNanos += this.endTiming();
        ++this.dbSequenceBatch;
    }

    public void recordCursorReads(int n, int n2, long l) {
        int n3 = (n + n2 - 1) / n2;
        this.dbDocReadNanos += l;
        this.dbDocReadRoundTrips += n3;
        this.dbCursorReads += n;
    }

    public void recordLobReads(int n) {
        if (n > 0) {
            this.dbLobReads += n;
        } else {
            this.dbLobReadNanos += this.endTiming();
        }
    }

    public void recordLobWrites(int n, int n2) {
        int n3 = (n + n2 - 1) / n2;
        this.dbLobWriteNanos += this.endTiming();
        this.dbDocWriteRoundTrips += n3;
        this.dbLobWrites += n;
    }

    public void recordStreamRead(int n) {
        this.ioReadNanos += this.endTiming();
        this.ioReadBytes += n;
    }

    public void recordStreamWrite(int n) {
        this.ioWriteNanos += this.endTiming();
        this.ioWriteBytes += n;
        if (n != 0) {
            ++this.ioWrites;
        }
    }

    public void recordChecksum() {
        this.checksumNanos += this.endTiming();
        ++this.checksums;
    }

    public void recordConnect() {
        this.dbConnectNanos += this.endTiming();
    }

    public void recordTransaction() {
        this.dbTransactionNanos += this.endTiming();
    }

    public String nanosToString(long l) {
        Formatter formatter = new Formatter(this.formattingBuffer);
        long l2 = l / 1000000000L;
        this.formattingBuffer.setLength(0);
        formatter.format("%d.%09d", (int)l2, (int)(l -= l2 * 1000000000L));
        formatter.close();
        return this.formattingBuffer.toString();
    }

    private void logMsgTime(StringBuilder stringBuilder, String string, long l) {
        stringBuilder.append(string);
        stringBuilder.append(this.nanosToString(l));
        stringBuilder.append("\n");
    }

    private void logMsgCount(StringBuilder stringBuilder, String string, int n) {
        stringBuilder.append(string);
        stringBuilder.append(Integer.toString(n));
        stringBuilder.append("\n");
    }

    private void logMsgCountTime(StringBuilder stringBuilder, String string, int n, long l) {
        stringBuilder.append(string);
        stringBuilder.append(Integer.toString(n));
        stringBuilder.append(" in ");
        stringBuilder.append(this.nanosToString(l));
        stringBuilder.append("\n");
    }

    public void logResults() {
        if (!OracleLog.isLoggingEnabled() || currentLogLevel > FINE_LOG_LEVEL) {
            return;
        }
        boolean bl = currentLogLevel < FINE_LOG_LEVEL;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n\n");
        if (bl || this.dbConnectNanos > 0L) {
            this.logMsgTime(stringBuilder, "JDBC connect in: ", this.dbConnectNanos);
        }
        if (bl || this.dbTransactionNanos > 0L) {
            this.logMsgTime(stringBuilder, "JDBC commit/rollback in: ", this.dbTransactionNanos);
        }
        if (bl || this.ioReadBytes > 0 || this.ioReadNanos > 0L) {
            this.logMsgCountTime(stringBuilder, "IO read: ", this.ioReadBytes, this.ioReadNanos);
        }
        if (bl || this.ioWrites > 0) {
            stringBuilder.append("IO writes: ");
            stringBuilder.append(Integer.toString(this.ioWrites));
            stringBuilder.append(" of ");
            stringBuilder.append(Integer.toString(this.ioWriteBytes));
            stringBuilder.append(" bytes in ");
            stringBuilder.append(this.nanosToString(this.ioWriteNanos));
            stringBuilder.append("\n");
        }
        if (bl || this.checksums > 0) {
            this.logMsgCountTime(stringBuilder, "Checksums: ", this.checksums, this.checksumNanos);
        }
        if (bl || this.dbDDLs > 0) {
            this.logMsgCountTime(stringBuilder, "DDLS: ", this.dbDDLs, this.dbDDLNanos);
        }
        if (bl || this.dbGUIDs > 0) {
            this.logMsgCountTime(stringBuilder, "GUID fetches: ", this.dbGUIDs, this.dbGUIDNanos);
        }
        if (bl || this.dbTimestampReads > 0) {
            this.logMsgCountTime(stringBuilder, "SYSTIMESTAMP reads: ", this.dbTimestampReads, this.dbTimestampNanons);
        }
        if (bl || this.dbSequenceBatch > 0) {
            this.logMsgCountTime(stringBuilder, "Sequence batch fetches: ", this.dbSequenceBatch, this.dbSequenceBatchNanos);
        }
        if (bl || this.dbCursorReads > 0) {
            this.logMsgCount(stringBuilder, "Cursor reads: ", this.dbCursorReads);
        }
        if (bl || this.dbLobReads > 0 || this.dbLobWrites > 0) {
            this.logMsgCountTime(stringBuilder, "LOB reads: ", this.dbLobReads, this.dbLobReadNanos);
            this.logMsgCountTime(stringBuilder, "LOB writes: ", this.dbLobWrites, this.dbLobWriteNanos);
        }
        if (bl || this.dbProcCalls > 0) {
            this.logMsgCountTime(stringBuilder, "PLSQL calls: ", this.dbProcCalls, this.dbProcCallNanos);
        }
        if (bl || this.dbDocReadRoundTrips > 0 || this.dbDocWriteRoundTrips > 0) {
            this.logMsgCountTime(stringBuilder, "Doc read round-trips: ", this.dbDocReadRoundTrips, this.dbDocReadNanos);
            this.logMsgCountTime(stringBuilder, "Doc write round-trips: ", this.dbDocWriteRoundTrips, this.dbDocWriteNanos);
        }
        if (this.encounteredNegativeTimeDiff) {
            stringBuilder.append("Warning: timings might be off, encountered negative time diff!!!\n");
        }
        long l = this.getTime() - this.total_time;
        this.logMsgTime(stringBuilder, "\nElapsed total: ", l);
        log.fine(stringBuilder.toString());
    }

    private static int getLogLevel() {
        Level level = null;
        for (Logger logger = log; logger != null && (level = logger.getLevel()) == null; logger = logger.getParent()) {
        }
        return level == null ? 0 : level.intValue();
    }
}

