/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.reports.text.TextReport;
import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSection;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledValue;
import com.oracle.premigration.reports.text.serialization.TextReportTable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class TextReportDescriptionTable
extends TextReportTable {
    private Map<String, TextValueHint> valueHints;
    protected List<?> descriptions;
    protected TextReportSectionName textReportSectionName;

    public TextReportDescriptionTable(TextReportContext reportContext, Field field, Object owningObject) {
        super(reportContext, field, owningObject);
    }

    @Override
    public List<Map<String, String>> getMapValues() {
        ArrayList<Map<String, String>> mapValues = new ArrayList<Map<String, String>>();
        this.valueHints = new HashMap<String, TextValueHint>();
        for (Object resultDescription : this.descriptions) {
            EnumMap<TextReportSectionName, TextReportSection> checkResultSections = new EnumMap<TextReportSectionName, TextReportSection>(TextReportSectionName.class);
            TextReport.scanFieldsToCreateSections(this.reportContext, checkResultSections, resultDescription);
            TreeMap<String, String> mapRow = new TreeMap<String, String>();
            TextReportSection descriptionSection = (TextReportSection)checkResultSections.get((Object)this.textReportSectionName);
            for (String key : descriptionSection.getFieldListKeySet()) {
                TextReportLabeledValue reportField = (TextReportLabeledValue)descriptionSection.getField(key);
                mapRow.put(reportField.getLabelText(), reportField.getValue().toString());
                this.valueHints.put(reportField.getLabelText(), reportField.getValueHint());
            }
            mapValues.add(mapRow);
        }
        return mapValues;
    }

    @Override
    public Map<String, TextValueHint> getMapHints() {
        return this.valueHints;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportDescriptionTable)) {
            return false;
        }
        TextReportDescriptionTable other = (TextReportDescriptionTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, TextValueHint> this$valueHints = this.valueHints;
        Map<String, TextValueHint> other$valueHints = other.valueHints;
        if (this$valueHints == null ? other$valueHints != null : !((Object)this$valueHints).equals(other$valueHints)) {
            return false;
        }
        List<?> this$descriptions = this.descriptions;
        List<?> other$descriptions = other.descriptions;
        if (this$descriptions == null ? other$descriptions != null : !((Object)this$descriptions).equals(other$descriptions)) {
            return false;
        }
        TextReportSectionName this$textReportSectionName = this.textReportSectionName;
        TextReportSectionName other$textReportSectionName = other.textReportSectionName;
        return !(this$textReportSectionName == null ? other$textReportSectionName != null : !((Object)((Object)this$textReportSectionName)).equals((Object)other$textReportSectionName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextReportDescriptionTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, TextValueHint> $valueHints = this.valueHints;
        result = result * 59 + ($valueHints == null ? 43 : ((Object)$valueHints).hashCode());
        List<?> $descriptions = this.descriptions;
        result = result * 59 + ($descriptions == null ? 43 : ((Object)$descriptions).hashCode());
        TextReportSectionName $textReportSectionName = this.textReportSectionName;
        result = result * 59 + ($textReportSectionName == null ? 43 : ((Object)((Object)$textReportSectionName)).hashCode());
        return result;
    }
}

