/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.text.TextProperty;
import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSection;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportField;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;

public class TextReport {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(TextReport.class.getName());

    private TextReport() {
    }

    public static String writeText(Object reportData, TextReportContext reportContext) throws Exception {
        TextReport.writeReportTitle(reportContext);
        EnumMap<TextReportSectionName, TextReportSection> reportSections = new EnumMap<TextReportSectionName, TextReportSection>(TextReportSectionName.class);
        TextReport.scanFieldsToCreateSections(reportContext, reportSections, reportData);
        Collection<TextReportSectionName> orderedSectionNames = TextReportSectionName.getOrderForPart(TextReportSectionName.Part.MAIN);
        for (TextReportSectionName sectionName : orderedSectionNames) {
            TextReportSection reportSection = (TextReportSection)reportSections.get((Object)sectionName);
            if (reportSection == null) continue;
            reportSection.printSection(reportContext);
        }
        TextReport.writeReportFooter(reportContext);
        reportContext.getPrintWriter().flush();
        reportContext.getPrintWriter().close();
        Utilities.throwExceptionForTesting("cpat.lrg.forceWriteErrorTest", "Forced Exception Test TXT");
        return reportContext.getTextReportPath();
    }

    public static void scanFieldsToCreateSections(TextReportContext reportContext, Map<TextReportSectionName, TextReportSection> reportSections, Object reportData) {
        if (reportData == null) {
            return;
        }
        Class<?> clazz = reportData.getClass();
        TextReport.scanFieldsToCreateSections(reportContext, reportSections, reportData, clazz);
    }

    public static void scanFieldsToCreateSections(TextReportContext reportContext, Map<TextReportSectionName, TextReportSection> reportSections, Object reportData, Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(TextProperty.class) && TextReportField.getTextValueHint(field) == TextValueHint.INLINED) {
                TextReport.scanFieldsToCreateSections(reportContext, reportSections, TextReportField.getValue(field, reportData));
                continue;
            }
            TextReportField textReportField = TextReportField.TextReportFieldFactory.createTextReportField(reportContext, field, reportData);
            if (textReportField == null) continue;
            TextReportSectionName sectionName = textReportField.getSectionName();
            TextReportSection section = reportSections.get((Object)sectionName);
            if (section == null) {
                section = new TextReportSection.TextReportSectionBuilder().sectionName(sectionName).build();
                reportSections.put(textReportField.getSectionName(), section);
            }
            section.addField(textReportField);
        }
    }

    private static void writeReportTitle(TextReportContext reportContext) {
        Language lang = Language.getInstance();
        PrintWriter w = reportContext.getPrintWriter();
        w.println(reportContext.getParallelDashedLine());
        w.println(lang.txt("REPORT_BANNER_TEXT"));
        w.println(reportContext.getParallelDashedLine());
    }

    private static void writeReportFooter(TextReportContext reportContext) {
        PrintWriter w = reportContext.getPrintWriter();
        w.println(reportContext.getParallelDashedLine());
    }
}

