/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.html;

import com.oracle.premigration.commons.io.ResourceFinder;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.reports.json.serialization.JsonSerializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class HtmlPdbReport {
    private static final Language lang = Language.getInstance();

    private HtmlPdbReport() {
    }

    public static String writeHtml(Object reportData, String htmlOutputFilename) throws IOException, PremigrationException {
        File reportFile = new File(htmlOutputFilename);
        FileWriter fileWriter = new FileWriter(reportFile);
        BufferedWriter writer = new BufferedWriter(fileWriter);
        PrintWriter printWriter = new PrintWriter(writer);
        String pdbSummaryStructure = new ResourceFinder("common/HtmlReport/pdbSummaryReport.html").getResourceAsText();
        String pdbSummaryReportContent = Utilities.mergeTags(pdbSummaryStructure, HtmlPdbReport.getMergeTagMap(reportData));
        printWriter.write(pdbSummaryReportContent);
        printWriter.flush();
        printWriter.close();
        return reportFile.getCanonicalPath();
    }

    private static Map<String, String> getMergeTagMap(Object cdbReportSummary) {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        String reportJson = JsonSerializer.toJson(cdbReportSummary).toString();
        tagMap.put("cpatPDBReport", reportJson);
        String oracleLogoSvg = new ResourceFinder("common/HtmlReport/Oracle_pms_180C.svg").getResourceAsText();
        tagMap.put("oracleLogo", oracleLogoSvg);
        tagMap.put("charset", System.getProperty("file.encoding"));
        tagMap.put("language", System.getProperty("user.language"));
        tagMap.put("title", lang.txt("PDB_SUMMARY_TITLE_HTML"));
        tagMap.put("appVersion", lang.txt("APP_VERSION_HTML"));
        tagMap.put("appBuildDate", lang.txt("APP_VERSION_DATE_HTML"));
        tagMap.put("buildDaysOld", lang.txt("APP_AGE_LABEL_HTML"));
        tagMap.put("appUpdateMessage", lang.txt("PDB_APP_UPDATE_HTML"));
        tagMap.put("appMosNoteURL", "https://support.oracle.com/epmos/faces/DocumentDisplay?id=2758371.1");
        tagMap.put("hostNameLabel", lang.txt("PDB_HOST_NAME_LABEL_HTML"));
        tagMap.put("commandLineLabel", lang.txt("REPORT_DETAILS_COMMAND_LINE_LABEL_HTML"));
        tagMap.put("pdbSummary", lang.txt("PDB_SUMMARY_HTML"));
        tagMap.put("openPdbsLabel", lang.txt("PDB_OPEN_PDBS_LABEL_HTML"));
        tagMap.put("closedPdbsLabel", lang.txt("PDB_CLOSED_PDBS_LABEL_HTML"));
        tagMap.put("pdbAnalysisOverview", lang.txt("PDB_ANALYSIS_OVERVIEW_HTML"));
        tagMap.put("analysisResult", lang.txt("PDB_ANALYSIS_RESULT_LABEL_HTML"));
        tagMap.put("htmlReport", lang.txt("PDB_HTML_REPORT_LABEL_HTML"));
        tagMap.put("textReport", lang.txt("PDB_TEXT_REPORT_LABEL_HTML"));
        tagMap.put("jsonReport", lang.txt("PDB_JSON_REPORT_LABEL_HTML"));
        tagMap.put("analysisDuration", lang.txt("PDB_ANALYSIS_DURATION_LABEL_HTML"));
        tagMap.put("analysisLogFile", lang.txt("PDB_ANALYSIS_LOG_FILE_LABEL_HTML"));
        tagMap.put("moreDetails", lang.txt("MORE_DETAILS_BUTTON_HTML"));
        tagMap.put("hideDetails", lang.txt("HIDE_DETAILS_BUTTON_HTML"));
        tagMap.put("year", String.valueOf(Calendar.getInstance().get(1)));
        return tagMap;
    }
}

