/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.security.keystorage;

import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStorage;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStoreManager;
import com.oracle.premigration.loadpwd.security.keystorage.PopulatedKeyStore;
import java.nio.file.Path;

public class ModifiableKeyStore
extends PopulatedKeyStore {
    private ModifiableKeyStore(EnvironmentContext envCtx) throws PremigrationException {
        super(new KeyStoreManager(KeyStorage.getInstance().getKeyStoreDir().orElseThrow(IllegalStateException::new), envCtx));
        this.keyStoreManager.init();
        if (KeyStorage.getInstance() instanceof ModifiableKeyStore) {
            throw new IllegalStateException();
        }
        KeyStorage.replaceKeyStore(this);
    }

    private ModifiableKeyStore(Path keyStore, EnvironmentContext envCtx) throws PremigrationException {
        super(keyStore, envCtx);
    }

    public static ModifiableKeyStore newInstanceForExistingKeystore(Path keyStore, EnvironmentContext envCtx) throws PremigrationException {
        return new ModifiableKeyStore(keyStore, envCtx);
    }

    public static ModifiableKeyStore newInstanceForEmptyKeystore(EnvironmentContext envCtx) throws PremigrationException {
        return new ModifiableKeyStore(envCtx);
    }

    public KeyStoreManager getKeyStoreManager() {
        return this.keyStoreManager;
    }
}

