/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.security.keystorage;

import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.loadpwd.security.keystorage.CommonPasswordConsoleUtils;
import com.oracle.premigration.loadpwd.security.keystorage.KeystorePasswordSupplier;
import com.oracle.premigration.loadpwd.security.keystorage.PopulatedKeyStore;
import com.oracle.premigration.loadpwd.security.keystorage.WalletState;
import com.oracle.premigration.loadpwd.security.pojos.WalletFile;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;

public class KeyStoreManager {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(KeyStoreManager.class.getName());
    public static final String CPAT_SEPS_ALIAS = "CPAT.TDE_SEPS";
    private OracleWallet oracleWallet = new OracleWallet();
    private final String keyStoreDir;
    private final Language lang = Language.getInstance();
    private final Path ewalletFile;
    private final Path cwalletFile;
    private WalletState walletState = WalletState.NEW;
    private final EnvironmentContext envCtx;
    private boolean isDirty = false;
    private boolean keystoreWasConverted = false;
    private static final KeystorePasswordSupplier<char[]> newWalletPassword = OraclePKIGenFunc::getCreatePassword;
    private static final KeystorePasswordSupplier<char[]> existingWalletPassword = () -> OraclePKIGenFunc.getPassword((String)"WALLET_PASSWORD_PROMPT");
    private static final KeystorePasswordSupplier<char[]> newSecretPassword = OraclePKIGenFunc::getSecret;

    KeyStoreManager(Path keyStore, EnvironmentContext envCtx) {
        this.keyStoreDir = keyStore.toString();
        this.ewalletFile = WalletFile.EWALLET.getFileName(this.keyStoreDir);
        this.cwalletFile = WalletFile.CWALLET.getFileName(this.keyStoreDir);
        this.envCtx = envCtx;
    }

    public OracleWallet getOracleWallet() {
        return this.oracleWallet;
    }

    String getKeyStoreDir() {
        return this.keyStoreDir;
    }

    void init() throws PremigrationException {
        if (Files.exists(this.ewalletFile, new LinkOption[0])) {
            this.load(null);
            if (this.hasAlias(CPAT_SEPS_ALIAS)) {
                this.convertToUserKeyStore();
            }
        } else {
            this.createWallet();
        }
    }

    private void createWallet() throws PremigrationException {
        this.keystoreWasConverted = this.walletState != WalletState.NEW;
        String keyStoreMsg = this.keystoreWasConverted ? this.lang.txt("KSM_UPDATE_KEYSTORE") : this.lang.txt("KSM_CREATE_KEYSTORE");
        Utilities.printAndLogMessage(keyStoreMsg, this.envCtx, Level.INFO);
        char[] m_cPwdA = null;
        try {
            m_cPwdA = newWalletPassword.get();
            this.oracleWallet.create(m_cPwdA);
            this.walletState = WalletState.PASSWORD;
            this.isDirty = true;
            keyStoreMsg = this.lang.txt(this.keystoreWasConverted ? "KSM_SUCCESSFULLY_UPDATED" : "KSM_SUCCESSFULLY_CREATED");
            Utilities.printAndLogMessage(keyStoreMsg, this.envCtx, Level.INFO);
        }
        catch (IOException e) {
            throw new PremigrationException("Creating keystore failed", e);
        }
        finally {
            Utilities.clearCharArray(m_cPwdA);
        }
    }

    void load(char[] pw) throws PremigrationException {
        String loadingMessage = this.lang.txt("KS_LOADING_EXISTING_KEYSTORE");
        Utilities.printAndLogMessage(loadingMessage, this.envCtx, Level.INFO);
        if (this.isCwalletFileExists()) {
            try {
                this.oracleWallet.open(this.keyStoreDir, null);
                this.walletState = WalletState.AUTO_LOGIN;
            }
            catch (IOException e) {
                throw new PremigrationException("Loading auto-login keystore failed", e);
            }
        } else {
            this.loadWithPassword(pw);
        }
        String loadedMessage = this.lang.txt("KSM_SUCCESSFULLY_LOADED");
        Utilities.printAndLogMessage(loadedMessage, this.envCtx, Level.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWithPassword(char[] pw) throws PremigrationException {
        int tryCount = 0;
        while (true) {
            try {
                char[] m_cPwdA = null;
                try {
                    m_cPwdA = pw != null ? pw : existingWalletPassword.get();
                    this.oracleWallet.open(this.keyStoreDir, m_cPwdA);
                    this.walletState = WalletState.PASSWORD;
                }
                catch (Throwable throwable) {
                    Utilities.clearCharArray(m_cPwdA);
                    throw throwable;
                }
                Utilities.clearCharArray(m_cPwdA);
            }
            catch (IOException e) {
                if (CommonPasswordConsoleUtils.isInvalidPasswordException(e)) {
                    if (++tryCount < 3) {
                        System.out.println();
                        Utilities.printAndLogMessage(this.lang.txt("KSM_WRONG_PASSWORD"), this.envCtx, Level.INFO);
                        continue;
                    }
                    log.warning(this.lang.txt("KSM_FAILED_LOAD_KEYSTORE"));
                    System.out.println();
                    throw new PremigrationException(this.lang.txt("KSM_FAILED_LOAD_KEYSTORE"));
                }
                throw new PremigrationException("Loading password keystore failed", e);
            }
            break;
        }
    }

    public void convertToUserKeyStore() throws PremigrationException {
        KeyStoreManager currentKeyStoreManager = new KeyStoreManager(Paths.get(this.keyStoreDir, new String[0]), this.envCtx);
        currentKeyStoreManager.oracleWallet = this.oracleWallet;
        currentKeyStoreManager.walletState = this.walletState;
        this.oracleWallet = new OracleWallet();
        this.createWallet();
        PopulatedKeyStore currentKeyStore = new PopulatedKeyStore(currentKeyStoreManager);
        for (String alias : currentKeyStore.getAllAliases()) {
            currentKeyStore.usePassword(pw -> this.addAlias(alias, () -> pw), alias);
        }
    }

    public void save(BufferedReader br) throws PremigrationException {
        log.info(this.lang.txt("KSM_START"));
        this.passwordWalletRequired();
        try {
            boolean promptForAutoLogin;
            this.oracleWallet.saveAs(this.keyStoreDir);
            boolean bl = promptForAutoLogin = !this.isCwalletFileExists() || this.keystoreWasConverted;
            if (promptForAutoLogin && CommonPasswordConsoleUtils.getYesNo(this.lang.txt("KSM_AUTO_LOGIN_PROMPT") + " ", br)) {
                this.oracleWallet.saveLSSO();
            } else if (this.keystoreWasConverted) {
                this.deleteAutoLoginSSO();
                this.keystoreWasConverted = false;
            }
        }
        catch (IOException e) {
            throw new PremigrationException("Saving keystore failed", e);
        }
        this.isDirty = false;
        log.info(this.lang.entxt("KSM_END"));
    }

    public void addAlias(String keystoreAlias) throws PremigrationException {
        this.addAlias(keystoreAlias, newSecretPassword);
    }

    public void addAlias(String keystoreAlias, KeystorePasswordSupplier<char[]> password) throws PremigrationException {
        log.info(this.lang.entxt("KSM_START"));
        this.passwordWalletRequired();
        char[] secret = null;
        try {
            OracleSecretStore store = this.oracleWallet.getSecretStore();
            secret = password.get();
            store.setSecret(keystoreAlias, secret);
            this.oracleWallet.setSecretStore(store);
        }
        catch (IOException | OracleSecretStoreException e) {
            try {
                throw new PremigrationException("Keystore operation failed", e);
            }
            catch (Throwable throwable) {
                Utilities.clearCharArray(secret);
                throw throwable;
            }
        }
        Utilities.clearCharArray(secret);
        this.isDirty = true;
        log.info(this.lang.entxt("KSM_END"));
    }

    public boolean deleteAlias(String keystoreAlias) throws PremigrationException {
        boolean deleteStatus;
        log.info(this.lang.entxt("KSM_START"));
        if (this.hasAlias(keystoreAlias)) {
            this.passwordWalletRequired();
            try {
                OracleSecretStore store = this.oracleWallet.getSecretStore();
                store.deleteSecret(keystoreAlias);
                this.oracleWallet.setSecretStore(store);
            }
            catch (IOException | OracleSecretStoreException e) {
                throw new PremigrationException("Keystore operation failed", e);
            }
            this.isDirty = true;
            deleteStatus = true;
        } else {
            deleteStatus = false;
        }
        log.info(this.lang.entxt("KSM_END"));
        return deleteStatus;
    }

    boolean hasAlias(String keystoreAlias) throws PremigrationException {
        if (keystoreAlias == null) {
            return false;
        }
        try {
            return this.oracleWallet.getSecretStore().containsAlias(keystoreAlias);
        }
        catch (IOException | OracleSecretStoreException e) {
            throw new PremigrationException("Keystore operation failed", e);
        }
    }

    private void passwordWalletRequired() throws PremigrationException {
        if (this.walletState != WalletState.PASSWORD) {
            System.out.println();
            Utilities.printAndLogMessage(this.lang.txt("KSM_PASSWORD_REQUIRED"), this.envCtx, Level.INFO);
            this.loadWithPassword(null);
            Utilities.printAndLogMessage(this.lang.txt("KSM_CONTINUING"), this.envCtx, Level.INFO);
            System.out.println();
        }
    }

    boolean isCwalletFileExists() {
        return Files.exists(this.cwalletFile, new LinkOption[0]);
    }

    private void deleteAutoLoginSSO() throws PremigrationException {
        log.info(this.lang.entxt("KSM_DELETE_SSO", this.isCwalletFileExists()));
        this.passwordWalletRequired();
        try {
            this.oracleWallet.deleteSSOWallet();
        }
        catch (IOException e) {
            throw new PremigrationException("Loading password keystore failed", e);
        }
    }

    public EnvironmentContext getEnvCtx() {
        return this.envCtx;
    }

    boolean hasBeenModifiedSinceBeingSaved() {
        return this.isDirty;
    }
}

