/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.helpers;

import java.util.List;

public class TablePrinter {
    public static void printTable(List<String[]> rows) {
        int[] columnWidths = TablePrinter.calculateColumnWidths(rows);
        TablePrinter.printSeparator(columnWidths);
        for (int i = 0; i < rows.size(); ++i) {
            TablePrinter.printRow(rows.get(i), columnWidths);
            if (i != 0) continue;
            TablePrinter.printSeparator(columnWidths);
        }
        TablePrinter.printSeparator(columnWidths);
    }

    private static int[] calculateColumnWidths(List<String[]> rows) {
        int columns = rows.get(0).length;
        int[] widths = new int[columns];
        for (String[] row : rows) {
            for (int i = 0; i < row.length; ++i) {
                if (row[i].length() <= widths[i]) continue;
                widths[i] = row[i].length();
            }
        }
        return widths;
    }

    private static void printSeparator(int[] columnWidths) {
        for (int width : columnWidths) {
            System.out.print("+");
            System.out.print(TablePrinter.repeat("-", width + 2));
        }
        System.out.println("+");
    }

    private static void printRow(String[] row, int[] columnWidths) {
        for (int i = 0; i < row.length; ++i) {
            System.out.print("| ");
            System.out.print(row[i]);
            System.out.print(TablePrinter.repeat(" ", columnWidths[i] - row[i].length() + 1));
        }
        System.out.println("|");
    }

    private static String repeat(String str, int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(str);
        }
        return builder.toString();
    }
}

