/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.helpers;

import com.oracle.premigration.cli.configuration.NameSpace;
import java.util.concurrent.atomic.AtomicReference;

public class Job {
    private final String dbName;
    private Stage stage;
    private final AtomicReference<Status> status;
    private NameSpace nameSpace;

    public Job(String dbName, Stage stage, Status status, NameSpace nameSpace) {
        this.dbName = dbName;
        this.stage = stage;
        this.status = new AtomicReference<Status>(status);
        this.nameSpace = nameSpace;
    }

    public boolean setStatus(Status newStatus) {
        return this.status.compareAndSet(Status.WAITING, newStatus) || this.status.compareAndSet(Status.RUNNING, newStatus);
    }

    public String getDbName() {
        return this.dbName;
    }

    public Stage getStage() {
        return this.stage;
    }

    public AtomicReference<Status> getStatus() {
        return this.status;
    }

    public NameSpace getNameSpace() {
        return this.nameSpace;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setNameSpace(NameSpace nameSpace) {
        this.nameSpace = nameSpace;
    }

    public static enum Stage {
        ANALYZED,
        NOT_ANALYZED,
        FAILED;

    }

    public static enum Status {
        WAITING,
        RUNNING,
        DONE;

    }
}

