/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.checks.unified_or_standard_audit_base;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.SQLException;
import java.util.logging.Level;

public abstract class unified_and_standard_traditional_audit
extends unified_or_standard_audit_base {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(unified_and_standard_traditional_audit.class.getName());

    protected unified_and_standard_traditional_audit() {
        this.multiPurposeResult = CheckResult.WARNING;
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        try {
            this.fetchAuditValues(exeCtx);
        }
        catch (SQLException e) {
            String errorMessage = Utilities.getErrorText("ERROR2000", this.getName());
            Utilities.printAndLogErrorMessage(errorMessage, exeCtx.getEnvCtx(), Level.SEVERE, e);
            this.skipCheck(errorMessage, CheckResult.FATAL);
            return;
        }
        if (!"TRUE".equals(this.unifiedAuditing)) {
            String skipMessage = this.lang.txt("CHECK.UNIFIED_OR_STANDARD_TRADITIONAL_AUDIT.SKIP_VALUE_OK", this.getName(), "V$OPTION/'Unified Auditing'", this.unifiedAuditing);
            this.skipCheck(skipMessage, CheckResult.PASS);
            return;
        }
        this.setAuditQuery(exeCtx);
    }
}

