/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.Arrays;
import java.util.List;

public abstract class timezone_table_compatibility_higher
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(timezone_table_compatibility_higher.class.getName());
    private String targetTzVersion;
    private boolean targetTzWasDerived;

    protected timezone_table_compatibility_higher() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.UNIVERSAL);
        this.setGrouping(Check.Group.OTHER);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String msg;
        this.targetTzVersion = exeCtx.getAnalysisProperty(TargetInstanceProp.TZ_VERSION.getKey());
        if (this.targetTzVersion != null) {
            this.targetTzWasDerived = false;
            if (!Utilities.isInteger(this.targetTzVersion)) {
                msg = this.lang.txt("CHECK.TIMEZONE_TABLE_COMPATIBILITY_HIGHER.WARNING_BAD_VALUE", TargetInstanceProp.TZ_VERSION.getKey());
                this.targetTzVersion = null;
                this.skipCheck(msg, CheckResult.WARNING);
            }
        } else {
            this.targetTzWasDerived = true;
            String targetDbVersionPropVal = exeCtx.getAnalysisProperty(TargetInstanceProp.DB_VERSION.getKey());
            this.targetTzVersion = this.inferTimezoneVersionFromDatabaseVersion(targetDbVersionPropVal);
            if (this.targetTzVersion == null) {
                this.targetTzVersion = this.inferTimezoneVersionFromTargetCloud(exeCtx.getParsedArgs().getTargetCloud());
            }
        }
        if (this.targetTzVersion == null) {
            msg = this.lang.txt("CHECK.TIMEZONE_TABLE_COMPATIBILITY_HIGHER.SKIPPED_NO_TARGET_TZ");
            this.skipCheck(msg, CheckResult.WARNING);
            return;
        }
        if (this.targetTzWasDerived) {
            msg = this.lang.txt("CHECK.TIMEZONE_TABLE_COMPATIBILITY_HIGHER.INFO_TARGET_TZ_INFERRED");
            this.setErrorMessage(msg);
        }
        this.setSqlQuery("SELECT '" + this.targetTzVersion + "' AS TARGET_TZ_VERSION, CAST(VERSION AS VARCHAR2(100)) AS SOURCE_TZ_VERSION FROM V$TIMEZONE_FILE");
    }

    @Override
    public CheckResult determineResult() {
        if (this.getRelevantObjectsData() == null || this.getRelevantObjectsData().size() != 1) {
            this.processInvalidValue("TZ_VERSION");
            return CheckResult.FATAL;
        }
        try {
            String srcTzStr = this.getRelevantObjectsData().get(0).get("SOURCE_TZ_VERSION");
            int srcTzNum = Integer.parseInt(srcTzStr);
            int targetTzNum = Integer.parseInt(this.targetTzVersion);
            log.info("using " + targetTzNum + " as target TZ_VERSION");
            if (srcTzNum <= targetTzNum) {
                return CheckResult.PASS;
            }
            return this.targetTzWasDerived ? CheckResult.WARNING : CheckResult.BLOCKER;
        }
        catch (Exception e) {
            this.processInvalidValue("TZ_VERSION", e);
            return CheckResult.BLOCKER;
        }
    }

    private String inferTimezoneVersionFromDatabaseVersion(String databaseVersion) {
        if (databaseVersion == null || databaseVersion.isEmpty()) {
            return null;
        }
        try {
            List<Integer> dbIntVers = Version.toList(databaseVersion);
            int minTimeZoneVersion = Version.getNearest(dbIntVers).getMinTimeZoneVersion();
            return Integer.toString(minTimeZoneVersion);
        }
        catch (Exception e) {
            this.processInvalidValue("TZ_VERSION", e);
            return null;
        }
    }

    private String inferTimezoneVersionFromTargetCloud(TargetCloud targetCloud) {
        if (targetCloud == TargetCloud.DEFAULT) {
            return null;
        }
        return Integer.toString(Version.V19_1_0_0.getMinTimeZoneVersion());
    }
}

