/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_unstructured_xml_indexes
extends FilterableCheck {
    public has_unstructured_xml_indexes() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("INDEX_OWNER").objectNameColumn("INDEX_NAME").objectTypeFixed("INDEX").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "INDEX_OWNER");
        boolean hasXmlIndexes = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").view("DBA_XML_INDEXES").build());
        if (hasXmlIndexes) {
            String xmlTablesSql = "SELECT INDEX_OWNER, INDEX_NAME, TABLE_OWNER, TABLE_NAME, TYPE, INDEX_TYPE FROM DBA_XML_INDEXES " + whereClause + " AND INDEX_TYPE != 'STRUCTURED'";
            this.setSqlQuery(xmlTablesSql);
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_COMPONENT_NOT_INSTALLED", this.getName(), "XDB"), CheckResult.PASS);
        }
    }
}

