/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.io.IOException;
import java.util.Arrays;

public class has_columns_with_spatial_data_types
extends FilterableCheck
implements Fixable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_columns_with_spatial_data_types.class.getName());

    public has_columns_with_spatial_data_types() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String javaStatusProperty = exeCtx.getAnalysisProperty(TargetInstanceProp.JAVAVM_STATUS.getKey(), "NOPE");
        if ("VALID".equalsIgnoreCase(javaStatusProperty)) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_JAVA_STATUS_VALID", this.getName()), CheckResult.PASS);
            return;
        }
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String sqlQuery = "SELECT OWNER, TABLE_NAME, COLUMN_NAME, DATA_TYPE  FROM SYS.DBA_TAB_COLUMNS " + whereClause + " AND DATA_TYPE IN ('SDO_PC','SDO_TIN','SDO_TOPO_GEOMETRY')  AND DATA_TYPE_OWNER IN ('MDSYS','PUBLIC')  ORDER BY 1,2,3";
        this.setSqlQuery(sqlQuery);
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "enable_javavm_spatial";
        Fixup.Locus locus = Fixup.Locus.target;
        Fixup fixupObject = Fixup.createStaticSqlFixupBuilder("enable_javavm_spatial", locus, parentFolderPath).restartRequired(true).build();
        this.generateStaticFixup(fixupObject);
    }
}

