/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.checks.gg_not_unique_base;
import com.oracle.premigration.helpers.SqlUtils;

public class gg_not_unique_bad_col_no
extends gg_not_unique_base {
    public gg_not_unique_bad_col_no() {
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean is18cOrLower;
        boolean bl = is18cOrLower = Version.V19_1_0_0.compare(exeCtx.getDatabaseVersion()) > 0;
        if (!is18cOrLower) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_UNSUPPORTED_VERSION", this.getName(), "18c", "lower"), CheckResult.PASS);
            return;
        }
        boolean hasGGNotUnique = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("DBA_GOLDENGATE_NOT_UNIQUE").build());
        if (!hasGGNotUnique) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "DBA_GOLDENGATE_NOT_UNIQUE", "TABLE"), CheckResult.INFORMATIONAL);
            return;
        }
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String sqlQuery = "SELECT OWNER, TABLE_NAME, BAD_COLUMN  FROM SYS.DBA_GOLDENGATE_NOT_UNIQUE " + whereClause + " AND BAD_COLUMN = 'N'  ORDER BY 1, 2";
        this.setSqlQuery(sqlQuery);
    }
}

