/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class InvalidObjects {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(InvalidObjects.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the object")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OBJ_TYPE", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The type of the object")
    private String objectType;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TOTAL", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total number of invalid objects")
    private long total;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<InvalidObjects> getInvalidObjectStats(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String query = "SELECT OWNER, OBJECT_TYPE, COUNT(*) AS TOTAL FROM DBA_OBJECTS" + whereClause + " AND STATUS = 'INVALID' GROUP BY OWNER, OBJECT_TYPE ORDER BY 1, 2";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<InvalidObjects> invalidObjectStats = new ArrayList<InvalidObjects>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                InvalidObjects invalidObjectStat = new InvalidObjects(rs.getString("OWNER"), rs.getString("OBJECT_TYPE"), rs.getLong("TOTAL"));
                invalidObjectStats.add(invalidObjectStat);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return invalidObjectStats;
    }

    public static InvalidObjectsBuilder builder() {
        return new InvalidObjectsBuilder();
    }

    private InvalidObjects(String owner, String objectType, long total) {
        this.owner = owner;
        this.objectType = objectType;
        this.total = total;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public long getTotal() {
        return this.total;
    }

    public static class InvalidObjectsBuilder {
        private String owner;
        private String objectType;
        private long total;

        InvalidObjectsBuilder() {
        }

        public InvalidObjectsBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public InvalidObjectsBuilder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public InvalidObjectsBuilder total(long total) {
            this.total = total;
            return this;
        }

        public InvalidObjects build() {
            return new InvalidObjects(this.owner, this.objectType, this.total);
        }

        public String toString() {
            return "InvalidObjects.InvalidObjectsBuilder(owner=" + this.owner + ", objectType=" + this.objectType + ", total=" + this.total + ")";
        }
    }
}

