/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.oee;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class NlsDatabaseParameter {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(NlsDatabaseParameter.class.getName());
    @HtmlProperty(labelKey="SRC_NLS_PARAMS_PARAMETER", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The name of the NLS database parameter.")
    private String parameter;
    @HtmlProperty(labelKey="SRC_NLS_PARAMS_VALUE", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The value of the NLS database parameter.")
    private String value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NlsDatabaseParameter> getNlsDatabaseParameters(ExecutionContext exeCtx) throws SQLException {
        ArrayList<NlsDatabaseParameter> nlsDatabaseParameters = new ArrayList<NlsDatabaseParameter>();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String redoSizeQuery = "SELECT PARAMETER, VALUE FROM SYS.NLS_DATABASE_PARAMETERS  ORDER BY PARAMETER ";
        log.fine("Fetching NLS Database Parameters with query: SELECT PARAMETER, VALUE FROM SYS.NLS_DATABASE_PARAMETERS  ORDER BY PARAMETER ");
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT PARAMETER, VALUE FROM SYS.NLS_DATABASE_PARAMETERS  ORDER BY PARAMETER ");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("PARAMETER");
                String value = rs.getString("VALUE");
                NlsDatabaseParameter databaseParameter = NlsDatabaseParameter.builder().parameter(name).value(value).build();
                nlsDatabaseParameters.add(databaseParameter);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return nlsDatabaseParameters;
    }

    public static NlsDatabaseParameterBuilder builder() {
        return new NlsDatabaseParameterBuilder();
    }

    private NlsDatabaseParameter(String parameter, String value) {
        this.parameter = parameter;
        this.value = value;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getValue() {
        return this.value;
    }

    public static class NlsDatabaseParameterBuilder {
        private String parameter;
        private String value;

        NlsDatabaseParameterBuilder() {
        }

        public NlsDatabaseParameterBuilder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public NlsDatabaseParameterBuilder value(String value) {
            this.value = value;
            return this;
        }

        public NlsDatabaseParameter build() {
            return new NlsDatabaseParameter(this.parameter, this.value);
        }

        public String toString() {
            return "NlsDatabaseParameter.NlsDatabaseParameterBuilder(parameter=" + this.parameter + ", value=" + this.value + ")";
        }
    }
}

