/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.oee;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DataGuard {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(DataGuard.class.getName());
    @HtmlProperty(labelKey="SRC_DB_DATAGUARD_FLOGGING_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the database is in force logging mode.")
    private String forceLogging;
    @HtmlProperty(labelKey="SRC_DB_DATAGUARD_BCTRACKING_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether change tracking is enabled.")
    private String blockChangeTracking;
    @HtmlProperty(labelKey="SRC_DB_DATAGUARD_CFILETYPE_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates the type of control file for the database.")
    private String controlfileType;
    @HtmlProperty(labelKey="SRC_DB_DATAGUARD_OPENMODE_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates the database mode (Is it read only? Is it read write?).")
    private String openMode;
    @HtmlProperty(labelKey="SRC_DB_DATAGUARD_PROTECTMODE_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates the protection mode currently in effect for the database.")
    private String protectionMode;
    @HtmlProperty(labelKey="SRC_DB_DATAGUARD_PROTECTLVL_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates the aggregated protection mode currently in effect for the database.")
    private String protectionLevel;
    @HtmlProperty(labelKey="SRC_DB_DATAGUARD_DBROLE_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates the current role of the database (Is it the primary DB? Is it standby?).")
    private String databaseRole;
    @HtmlProperty(labelKey="SRC_DB_DATAGUARD_BROKER_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the Data Guard broker is enabled.")
    private String dataguardBroker;
    @HtmlProperty(labelKey="SRC_DB_DATAGUARD_FLASHBACKDB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether DB flashback is enabled.")
    private String flashbackDB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataGuard getDataGuard(ExecutionContext exeCtx) throws SQLException {
        DataGuard dataguard = null;
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String dataGuardQuery = "SELECT   FORCE_LOGGING,   TO_CHAR((SELECT max(STATUS) FROM v$block_change_tracking)) AS BLOCK_CHANGE_TRACKING,   CONTROLFILE_TYPE,   OPEN_MODE,   PROTECTION_MODE,   PROTECTION_LEVEL,   DATABASE_ROLE,   DATAGUARD_BROKER,   FLASHBACK_ON AS FLASHBACK_DB FROM V$DATABASE";
        log.fine("Fetching Data Guard details with query: SELECT   FORCE_LOGGING,   TO_CHAR((SELECT max(STATUS) FROM v$block_change_tracking)) AS BLOCK_CHANGE_TRACKING,   CONTROLFILE_TYPE,   OPEN_MODE,   PROTECTION_MODE,   PROTECTION_LEVEL,   DATABASE_ROLE,   DATAGUARD_BROKER,   FLASHBACK_ON AS FLASHBACK_DB FROM V$DATABASE");
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT   FORCE_LOGGING,   TO_CHAR((SELECT max(STATUS) FROM v$block_change_tracking)) AS BLOCK_CHANGE_TRACKING,   CONTROLFILE_TYPE,   OPEN_MODE,   PROTECTION_MODE,   PROTECTION_LEVEL,   DATABASE_ROLE,   DATAGUARD_BROKER,   FLASHBACK_ON AS FLASHBACK_DB FROM V$DATABASE");
            rs = stmt.executeQuery();
            if (rs.next()) {
                dataguard = DataGuard.builder().forceLogging(rs.getString("FORCE_LOGGING")).blockChangeTracking(rs.getString("BLOCK_CHANGE_TRACKING")).controlfileType(rs.getString("CONTROLFILE_TYPE")).openMode(rs.getString("OPEN_MODE")).protectionMode(rs.getString("PROTECTION_MODE")).protectionLevel(rs.getString("PROTECTION_LEVEL")).forceLogging(rs.getString("FORCE_LOGGING")).databaseRole(rs.getString("DATABASE_ROLE")).dataguardBroker(rs.getString("DATAGUARD_BROKER")).flashbackDB(rs.getString("FLASHBACK_DB")).build();
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return dataguard;
    }

    public static DataGuardBuilder builder() {
        return new DataGuardBuilder();
    }

    private DataGuard(String forceLogging, String blockChangeTracking, String controlfileType, String openMode, String protectionMode, String protectionLevel, String databaseRole, String dataguardBroker, String flashbackDB) {
        this.forceLogging = forceLogging;
        this.blockChangeTracking = blockChangeTracking;
        this.controlfileType = controlfileType;
        this.openMode = openMode;
        this.protectionMode = protectionMode;
        this.protectionLevel = protectionLevel;
        this.databaseRole = databaseRole;
        this.dataguardBroker = dataguardBroker;
        this.flashbackDB = flashbackDB;
    }

    public String getForceLogging() {
        return this.forceLogging;
    }

    public String getBlockChangeTracking() {
        return this.blockChangeTracking;
    }

    public String getControlfileType() {
        return this.controlfileType;
    }

    public String getOpenMode() {
        return this.openMode;
    }

    public String getProtectionMode() {
        return this.protectionMode;
    }

    public String getProtectionLevel() {
        return this.protectionLevel;
    }

    public String getDatabaseRole() {
        return this.databaseRole;
    }

    public String getDataguardBroker() {
        return this.dataguardBroker;
    }

    public String getFlashbackDB() {
        return this.flashbackDB;
    }

    public static class DataGuardBuilder {
        private String forceLogging;
        private String blockChangeTracking;
        private String controlfileType;
        private String openMode;
        private String protectionMode;
        private String protectionLevel;
        private String databaseRole;
        private String dataguardBroker;
        private String flashbackDB;

        DataGuardBuilder() {
        }

        public DataGuardBuilder forceLogging(String forceLogging) {
            this.forceLogging = forceLogging;
            return this;
        }

        public DataGuardBuilder blockChangeTracking(String blockChangeTracking) {
            this.blockChangeTracking = blockChangeTracking;
            return this;
        }

        public DataGuardBuilder controlfileType(String controlfileType) {
            this.controlfileType = controlfileType;
            return this;
        }

        public DataGuardBuilder openMode(String openMode) {
            this.openMode = openMode;
            return this;
        }

        public DataGuardBuilder protectionMode(String protectionMode) {
            this.protectionMode = protectionMode;
            return this;
        }

        public DataGuardBuilder protectionLevel(String protectionLevel) {
            this.protectionLevel = protectionLevel;
            return this;
        }

        public DataGuardBuilder databaseRole(String databaseRole) {
            this.databaseRole = databaseRole;
            return this;
        }

        public DataGuardBuilder dataguardBroker(String dataguardBroker) {
            this.dataguardBroker = dataguardBroker;
            return this;
        }

        public DataGuardBuilder flashbackDB(String flashbackDB) {
            this.flashbackDB = flashbackDB;
            return this;
        }

        public DataGuard build() {
            return new DataGuard(this.forceLogging, this.blockChangeTracking, this.controlfileType, this.openMode, this.protectionMode, this.protectionLevel, this.databaseRole, this.dataguardBroker, this.flashbackDB);
        }

        public String toString() {
            return "DataGuard.DataGuardBuilder(forceLogging=" + this.forceLogging + ", blockChangeTracking=" + this.blockChangeTracking + ", controlfileType=" + this.controlfileType + ", openMode=" + this.openMode + ", protectionMode=" + this.protectionMode + ", protectionLevel=" + this.protectionLevel + ", databaseRole=" + this.databaseRole + ", dataguardBroker=" + this.dataguardBroker + ", flashbackDB=" + this.flashbackDB + ")";
        }
    }
}

