/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.addinform.CloudService;
import com.oracle.premigration.dbinspector.addinform.DatabaseSize;
import com.oracle.premigration.dbinspector.addinform.InstalledPackage;
import com.oracle.premigration.dbinspector.addinform.PackagesList;
import com.oracle.premigration.dbinspector.addinform.RedoData;
import com.oracle.premigration.dbinspector.addinform.SchemaSummary;
import com.oracle.premigration.dbinspector.addinform.TablespaceData;
import com.oracle.premigration.dbinspector.addinform.VendorsList;
import com.oracle.premigration.dbinspector.addinform.dbsize.DatabaseSizeDetails;
import com.oracle.premigration.dbinspector.addinform.oee.DataGuard;
import com.oracle.premigration.dbinspector.addinform.oee.DatabaseOption;
import com.oracle.premigration.dbinspector.addinform.oee.DatabaseParameter;
import com.oracle.premigration.dbinspector.addinform.oee.InstanceState;
import com.oracle.premigration.dbinspector.addinform.oee.MemoryCPUInfo;
import com.oracle.premigration.dbinspector.addinform.oee.MpackMetrics;
import com.oracle.premigration.dbinspector.addinform.oee.NlsDatabaseParameter;
import com.oracle.premigration.dbinspector.addinform.oee.SupplementalLogging;
import com.oracle.premigration.dbinspector.addinform.supplemental.DatabaseTrigger;
import com.oracle.premigration.dbinspector.addinform.supplemental.HighWaterMarkStat;
import com.oracle.premigration.dbinspector.addinform.supplemental.HybridColumnarCompressionTable;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InfoCollector {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(InfoCollector.class.getName());

    private InfoCollector() {
    }

    public static CloudService detectCloudVendor(ExecutionContext exeCtx) throws SQLException {
        List<CloudService> cloudServices = VendorsList.createVendorsList();
        for (CloudService cloudService : cloudServices) {
            cloudService.prepare();
            if (!cloudService.determineResult(exeCtx)) continue;
            return cloudService;
        }
        return null;
    }

    public static List<InstalledPackage> detectPackageInstalled(ExecutionContext exeCtx) throws SQLException {
        List<InstalledPackage> installedPackageList = PackagesList.createInstalledPackageList();
        ArrayList<InstalledPackage> installedPackageInTheSource = new ArrayList<InstalledPackage>();
        for (InstalledPackage installedPackage : installedPackageList) {
            installedPackage.prepare();
            if (!installedPackage.determineIfPackageIsInstalled(exeCtx)) continue;
            installedPackageInTheSource.add(installedPackage);
        }
        return installedPackageInTheSource.isEmpty() ? null : installedPackageInTheSource;
    }

    public static RedoData getRedoData(ExecutionContext exeCtx) {
        return RedoData.getRedoData(exeCtx);
    }

    public static DatabaseSizeDetails getDatabaseSizeDetails(ExecutionContext exeCtx) {
        return DatabaseSize.getDatabaseSizeDetails(exeCtx);
    }

    public static List<HybridColumnarCompressionTable> getHCCTableData(ExecutionContext exeCtx) {
        try {
            return HybridColumnarCompressionTable.getHCCTableData(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching HCC Table Data", e);
            return Collections.emptyList();
        }
    }

    public static List<HighWaterMarkStat> getHighWaterMarkData(ExecutionContext exeCtx) {
        try {
            return HighWaterMarkStat.getHighWaterMarkData(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching HWM statistics", e);
            return Collections.emptyList();
        }
    }

    public static List<DatabaseTrigger> getLogonTriggerData(ExecutionContext exeCtx) {
        try {
            return DatabaseTrigger.getLogonTriggerData(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching LOGON triggers", e);
            return Collections.emptyList();
        }
    }

    public static SchemaSummary getSchemaSummaryData(ExecutionContext exeCtx) {
        try {
            return SchemaSummary.getSchemaSummaryData(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching Schema Summary Data", e);
            return null;
        }
    }

    public static DataGuard getDataGuardInfo(ExecutionContext exeCtx) {
        try {
            return DataGuard.getDataGuard(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching Database Options", e);
            return null;
        }
    }

    public static SupplementalLogging getSupplementalLoggingSettings(ExecutionContext exeCtx) {
        try {
            return SupplementalLogging.getSupplementalLoggingSettings(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching Supplemental Logging Settings", e);
            return null;
        }
    }

    public static TablespaceData getTablespaceInfo(ExecutionContext exeCtx) {
        return TablespaceData.getTablespaceData(exeCtx);
    }

    public static List<DatabaseParameter> getDatabaseParameters(ExecutionContext exeCtx) {
        try {
            return DatabaseParameter.getDatabaseParameters(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching Database Parameters", e);
            return null;
        }
    }

    public static List<NlsDatabaseParameter> getNlsDatabaseParameters(ExecutionContext exeCtx) {
        try {
            return NlsDatabaseParameter.getNlsDatabaseParameters(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching NLS Database Parameters", e);
            return null;
        }
    }

    public static List<InstanceState> getInstanceState(ExecutionContext exeCtx) {
        try {
            return InstanceState.getInstanceState(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching Instance State", e);
            return null;
        }
    }

    public static List<DatabaseOption> getDatabaseOptions(ExecutionContext exeCtx) {
        try {
            return DatabaseOption.getDatabaseOptions(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching Database Options", e);
            return null;
        }
    }

    public static MemoryCPUInfo getMemoryCPUInfo(ExecutionContext exeCtx) {
        try {
            return MemoryCPUInfo.getMemoryCPUInfo(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching Memory and CPU information", e);
            return null;
        }
    }

    public static MpackMetrics getMpackMetrics(ExecutionContext exeCtx) {
        try {
            return MpackMetrics.getMpackMetrics(exeCtx);
        }
        catch (SQLException e) {
            log.severe("Unexpected error fetching MPACK metrics. Resulting file may not present accurate information", e);
            return null;
        }
    }
}

