/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.cli.CommandInvocationMode;
import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.enums.AnalysisMode;
import com.oracle.premigration.commons.enums.GatherDetailsOptions;
import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.commons.enums.ReportNote;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.commons.io.OutputFilenamesContainer;
import com.oracle.premigration.commons.io.ResourceFinder;
import com.oracle.premigration.commons.io.ZipContributor;
import com.oracle.premigration.commons.io.ZipFileHelper;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckList;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.CheckRunner;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.SourceApplications;
import com.oracle.premigration.dbinspector.addinform.InfoCollector;
import com.oracle.premigration.dbinspector.addinform.OracleEstateExplorer;
import com.oracle.premigration.dbinspector.addinform.SchemaSummary;
import com.oracle.premigration.dbinspector.addinform.oee.MpackMetrics;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.AnalysisPropHelper;
import com.oracle.premigration.helpers.AppVersion;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.AnalysisNotes;
import com.oracle.premigration.reports.ChecksSummary;
import com.oracle.premigration.reports.ReportData;
import com.oracle.premigration.reports.filters.FilterCriteria;
import com.oracle.premigration.reports.html.HtmlReport;
import com.oracle.premigration.reports.json.serialization.JsonSerializer;
import com.oracle.premigration.reports.text.TextReport;
import com.oracle.premigration.reports.text.TextReportContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class SourceInspector {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(SourceInspector.class.getName());
    private static final Language lang = Language.getInstance();

    private SourceInspector() {
    }

    /*
     * Unable to fully structure code
     */
    public static CheckResult analyzeSource(ExecutionContext exeCtx, String appVersion) throws Exception {
        reportData = new ReportData();
        cla = exeCtx.getParsedArgs();
        envCtx = exeCtx.getEnvCtx();
        reportAnalysisNotes = new ArrayList<String>();
        mpackMetrics = null;
        overallResult = CheckResult.PASS;
        if (cla.getAnalysisPropertiesFile() != null) {
            propFilePath = cla.getAnalysisPropertiesFile();
            fileStream = new FileInputStream(propFilePath);
            try {
                analysisProps = SourceInspector.deserializeAnalysisProps(fileStream);
                AnalysisPropHelper.processAnalysisProperties(analysisProps, appVersion, reportAnalysisNotes, exeCtx);
                exeCtx.getAnalysisProperties().putAll((Map<?, ?>)analysisProps);
                nonFatalErrors = new ArrayList<PremigrationException>();
                filterCriteria = FilterCriteria.fromProperties(analysisProps, nonFatalErrors);
                exeCtx.setFilterCriteria(filterCriteria);
                for (PremigrationException pe : nonFatalErrors) {
                    envCtx.getErrWriter().println(pe.getMessage());
                }
                reportData.setAnalysisPropertiesFile(cla.getAnalysisPropertiesFile());
                if (!cla.isGenZipFile()) ** GOTO lbl34
                propFileName = new File(propFilePath).getName();
                propFileForZip = ZipFileHelper.createZipContributorForFile(propFileName, propFilePath);
                exeCtx.getZipContents().add(propFileForZip);
            }
            finally {
                fileStream.close();
            }
        } else {
            reportAnalysisNotes.add(Utilities.getAnalysisNoteText("ERROR1013", new Object[0]));
            noPropsFileMsg = Utilities.getErrorText("ERROR1013", new String[0]);
            Utilities.printAndLogErrorMessage(noPropsFileMsg, envCtx, Level.INFO);
        }
lbl34:
        // 3 sources

        defaultPropFileStream = new ResourceFinder("common/defaultProperties/default.properties").getResourceAsStream();
        try {
            defaultAnalysisProps = SourceInspector.deserializeAnalysisProps(defaultPropFileStream);
            exeCtx.getDefaultAnalysisProperties().putAll((Map<?, ?>)defaultAnalysisProps);
        }
        finally {
            if (defaultPropFileStream != null) {
                defaultPropFileStream.close();
            }
        }
        reportData.setAnalysisMode(exeCtx.getAnalysisMode());
        reportAnalysisNotes.add(Utilities.getAnalysisNoteText(exeCtx.getAnalysisMode() == AnalysisMode.FULL ? "ERROR1016" : "ERROR1017", new Object[0]));
        if (exeCtx.getParsedArgs().getTargetCloud() == null) {
            severeMessage = Utilities.getErrorText("ERROR1015", new String[0]);
            Utilities.printAndLogErrorMessage((String)severeMessage, envCtx, Level.SEVERE);
            return CheckResult.FATAL;
        }
        SqlUtils.validateSourceEdition(exeCtx, reportAnalysisNotes);
        reportData.setAppVersion(appVersion);
        reportData.setChecksVersion(appVersion);
        reportData.setReportDate(new Date());
        reportData.setHostName(Utilities.getHostName());
        reportData.setTargetMigrationStrategies(MigrationMethod.getNormalizedListOfMethods(cla.getMigrationMethods()));
        reportData.setCommandLineOptions(cla.getReconstitutedArgs());
        reportData.setAbsoluteOutputPath(exeCtx.getOutputFilenamesContainer().getOutDir());
        for (CheckResult checkResult : CheckResult.values()) {
            reportData.getCheckResultDescriptions().add(checkResult.toCheckResultDescription(SourceInspector.lang));
        }
        reportData.getReportNotes().addAll(ReportNote.toReportNotesList());
        reportData.setSrcDatabasePortString(exeCtx.getDatabasePlatformHW() + "/" + exeCtx.getDatabasePlatformOS());
        reportData.setSrcDatabasePlatformID(exeCtx.getDatabasePlatformID());
        instanceName = SqlUtils.getSingleString("SELECT INSTANCE_NAME FROM V$INSTANCE", exeCtx);
        reportData.setSrcInstanceName(instanceName);
        reportData.setSrcOracleSID(instanceName);
        reportData.setSrcDataBaseHostName(SqlUtils.getSingleString("SELECT HOST_NAME FROM V$INSTANCE", exeCtx));
        reportData.setSrcDatabaseName(SqlUtils.getSingleString("SELECT NAME FROM V$DATABASE", exeCtx));
        reportData.setSrcDatabaseDBID(SqlUtils.getSingleLong("SELECT DBID FROM V$DATABASE", exeCtx));
        reportData.setSrcDatabaseCreatedDate(SqlUtils.getSingleDate("SELECT CREATED FROM V$DATABASE", exeCtx));
        reportData.setSrcDatabaseUniqueName(SqlUtils.getSingleString("SELECT DB_UNIQUE_NAME FROM V$DATABASE", exeCtx));
        sourceVersion = exeCtx.getDatabaseVersion();
        reportData.setSrcDatabaseVersion(sourceVersion);
        appAgeInDays = AppVersion.getAppAgeInDays();
        if (appAgeInDays >= 90 && envCtx.getCommandInvocationMode() == CommandInvocationMode.RUN_FROM_CLI) {
            appAgeInDaysString = appAgeInDays + "";
            reportAnalysisNotes.add(Utilities.getAnalysisNoteText("ERROR4007", new Object[]{appAgeInDaysString, Utilities.getPremigrationCommand()}));
            parseMsg = Utilities.getErrorText("ERROR4007", new String[]{appAgeInDaysString, Utilities.getPremigrationCommand()});
            Utilities.printAndLogErrorMessage(parseMsg, envCtx, Level.WARNING);
        }
        if (Version.V11_2_0_4.compare(sourceVersion) == 1) {
            errorMsg = Utilities.getErrorText("ERROR4003", new String[]{Version.V11_2_0_4.toString(), sourceVersion});
            Utilities.printAndLogErrorMessage(errorMsg, envCtx, Level.WARNING);
            if (Version.V10_1_0_2.compare(sourceVersion) == 1) {
                return CheckResult.FATAL;
            }
            allowUnsupportedVersionMsg = SourceInspector.lang.txt("APP_ALLOW_UNSUPPORTED_VERSION");
            Utilities.printAndLogMessage(allowUnsupportedVersionMsg, envCtx, Level.WARNING);
        }
        if ((srcDatabaseLockdown = exeCtx.getLockdownProfile()) != null && srcDatabaseLockdown != LockdownProfile.NONE) {
            if (srcDatabaseLockdown.isSupportedLockdownProfile()) {
                infoMessage = Utilities.getErrorText("ERROR4005", new String[]{srcDatabaseLockdown.toString()});
                Utilities.printAndLogErrorMessage(infoMessage, envCtx, Level.INFO);
            } else {
                warningMessage = Utilities.getErrorText("ERROR4006", new String[0]);
                Utilities.printAndLogErrorMessage(warningMessage, envCtx, Level.WARNING);
            }
        }
        reportData.setSrcDatabaseUser(SqlUtils.getSingleString("SELECT USER FROM DUAL", exeCtx));
        reportData.setSrcNumSchemasPresent(SqlUtils.getSingleLong("SELECT COUNT(*) AS NUM_SCHEMAS FROM SYS.DBA_USERS", exeCtx));
        reportData.setSrcDatabasePatchInfo(SqlUtils.getPatchInfo(exeCtx));
        reportData.setSrcDatabaseVersionData(SqlUtils.getVersionData(exeCtx));
        reportData.setSrcContainerName(exeCtx.getContainerName());
        reportData.setTargetCloudType(exeCtx.getParsedArgs().getTargetCloud());
        invalidNames = exeCtx.getInvalidSchemaNames();
        if (!invalidNames.isEmpty()) {
            errorMsg = Utilities.getErrorText("ERROR1002", new String[]{Utilities.join(", ", invalidNames)});
            Utilities.printAndLogErrorMessage(errorMsg, envCtx, Level.SEVERE);
            return CheckResult.FATAL;
        }
        reportData.setSrcSchemasAnalyzed(SqlUtils.getAnalysedSchemaNames(exeCtx));
        reportData.setSrcNumSchemasAnalyzed(reportData.getSrcSchemasAnalyzed().size());
        reportData.setSrcDatabaseCompatible(exeCtx.getDatabaseCompatibilityVersion());
        reportData.setSrcApplications(SourceApplications.checkIfAppIsRunning(exeCtx));
        reportData.setCloudService(InfoCollector.detectCloudVendor(exeCtx));
        reportData.setInstalledPackages(InfoCollector.detectPackageInstalled(exeCtx));
        reportData.setSrcRedoData(InfoCollector.getRedoData(exeCtx));
        reportData.setSrcDbSizeDetails(InfoCollector.getDatabaseSizeDetails(exeCtx));
        reportData.setSrcHighWaterMarkStatistics(InfoCollector.getHighWaterMarkData(exeCtx));
        reportData.setSrcLogonTriggers(InfoCollector.getLogonTriggerData(exeCtx));
        reportData.setSrcHCCTables(InfoCollector.getHCCTableData(exeCtx));
        if (SchemaSummary.isSchemaSummaryRequested(cla.getGatherDetailsOptions())) {
            reportData.setSrcSchemaSummary(InfoCollector.getSchemaSummaryData(exeCtx));
        }
        if (OracleEstateExplorer.isOEEDataRequested(cla.getGatherDetailsOptions())) {
            reportData.setSrcMemoryCPUInfo(InfoCollector.getMemoryCPUInfo(exeCtx));
            reportData.setSrcDatabaseOptions(InfoCollector.getDatabaseOptions(exeCtx));
            reportData.setSrcDbDataGuardDetails(InfoCollector.getDataGuardInfo(exeCtx));
            reportData.setSrcNlsDatabaseParameters(InfoCollector.getNlsDatabaseParameters(exeCtx));
            reportData.setSrcDbSupplementalLoggingSettings(InfoCollector.getSupplementalLoggingSettings(exeCtx));
            reportData.setSrcDatabaseTablespaceInfo(InfoCollector.getTablespaceInfo(exeCtx));
            reportData.setSrcInstanceState(InfoCollector.getInstanceState(exeCtx));
            reportData.setSrcDatabaseParameters(InfoCollector.getDatabaseParameters(exeCtx));
            cpatKeyRequiredOptions = EnumSet.of(GatherDetailsOptions.OEE, GatherDetailsOptions.OEE_FULL);
            if (!Collections.disjoint(cla.getGatherDetailsOptions(), cpatKeyRequiredOptions)) {
                if (cla.getCpatKey() == null || cla.getCpatKey().isEmpty()) {
                    uniqueLabel = reportData.getSrcDatabaseUniqueName() + reportData.getSrcDatabaseName() + reportData.getSrcDatabaseDBID() + reportData.getSrcDatabaseCreatedDate() + reportData.getSrcDataBaseHostName() + reportData.getSrcInstanceName();
                    reportData.setCpatKey(SourceInspector.generateMD5(uniqueLabel));
                    reportData.setIsCpatKeyAutoGenerated("TRUE");
                } else {
                    reportData.setCpatKey(cla.getCpatKey());
                    reportData.setIsCpatKeyAutoGenerated("FALSE");
                }
            }
            if (OracleEstateExplorer.isFullOEEDataRequested(cla.getGatherDetailsOptions())) {
                mpackMetrics = InfoCollector.getMpackMetrics(exeCtx);
            }
        }
        fullCheckList = CheckList.createChecksList();
        filteredCheckList = CheckList.filterChecksByTargetCloud(fullCheckList, exeCtx.getParsedArgs().getTargetCloud());
        filteredCheckList = CheckList.filterChecksByMigrationMethod(filteredCheckList, exeCtx.getParsedArgs().getMigrationMethods());
        filteredCheckList = CheckList.filterChecksByScope(filteredCheckList, exeCtx.getParsedArgs());
        filteredCheckList = CheckList.filterChecksByLockdownProfile(filteredCheckList, exeCtx.getLockdownProfile());
        reportData.setCheckList(filteredCheckList);
        for (Check check : filteredCheckList) {
            if (exeCtx.getSkipChecks().contains(check.getName())) {
                skipMessage = SourceInspector.lang.txt("CHECK_SKIPPED_BECAUSE_SKIP_PROPERTY", new Object[]{check.getName()});
                check.skipCheck(skipMessage, CheckResult.INFORMATIONAL);
                continue;
            }
            startPrepare = System.currentTimeMillis();
            check.prepare(exeCtx);
            SourceInspector.log.info("Elapsed time preparing " + check.getName() + ": " + Utilities.formatTimeInterval(System.currentTimeMillis() - startPrepare));
        }
        count = 0;
        numChecks = filteredCheckList.size();
        SourceInspector.log.info("Beginning execution of " + numChecks + " Checks...");
        startAllChecks = System.currentTimeMillis();
        for (Check check : filteredCheckList) {
            startCheck = System.currentTimeMillis();
            CheckRunner.runCheck(exeCtx, check, reportAnalysisNotes);
            elapsed = "Elapsed time running " + check.getName() + ": " + Utilities.formatTimeInterval(System.currentTimeMillis() - startCheck);
            SourceInspector.log.info(elapsed);
            msg = "Completed check " + ++count + " of " + numChecks + " (" + check.getName() + "). Check result: " + (Object)check.getResult();
            SourceInspector.log.info(msg);
            overallResult = CheckResult.max(overallResult, check.getResult());
        }
        SourceInspector.log.info("...completed execution of Checks.");
        SourceInspector.log.info("Elapsed time running checks: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startAllChecks));
        reportData.setResult(overallResult);
        reportData.getAnalysisNotes().addAll(AnalysisNotes.fromStringList(reportAnalysisNotes, overallResult));
        cpatResultCompleted = SourceInspector.lang.txt("APP_COMPLETED_MSG", new Object[]{overallResult.toString()});
        Utilities.printAndLogMessage(cpatResultCompleted, envCtx, Level.INFO);
        Collections.sort(reportData.getCheckList(), Check.groupByResult);
        reportData.setChecksSummary(new ChecksSummary(reportData));
        if (reportData.getChecksSummary().getFixupsSummary() != null) {
            Utilities.printAndLogMessage(reportData.getChecksSummary().getFixupsSummary(), envCtx, Level.INFO);
        }
        SourceInspector.writeReports(reportData, mpackMetrics, exeCtx);
        return overallResult;
    }

    private static void writeReports(ReportData reportData, MpackMetrics mpackMetrics, ExecutionContext exeCtx) throws PremigrationException {
        CommandLineArgs cla = exeCtx.getParsedArgs();
        EnvironmentContext envCtx = exeCtx.getEnvCtx();
        boolean deferredException = false;
        for (ReportFormat reportFormat : cla.getReportFormats()) {
            OutputFilenamesContainer namesContainer = exeCtx.getOutputFilenamesContainer();
            long startSerialization = System.currentTimeMillis();
            try {
                String createdFilePath;
                String filePath;
                String fileName;
                switch (reportFormat) {
                    case JSON: {
                        String jsonPath = namesContainer.getValidatedJSONReportPath();
                        fileName = namesContainer.getJsonOutputFilename();
                        filePath = namesContainer.getValidatedJSONReportPath();
                        createdFilePath = JsonSerializer.writeJSON(reportData, jsonPath);
                        break;
                    }
                    case TEXT: {
                        String textPath = namesContainer.getValidatedTextReportPath();
                        fileName = namesContainer.getTextOutputFilename();
                        filePath = namesContainer.getValidatedTextReportPath();
                        TextReportContext textReportContext = TextReportContext.createTextReportContext(cla, textPath);
                        createdFilePath = TextReport.writeText(reportData, textReportContext);
                        break;
                    }
                    case HTML: {
                        String htmlPath = namesContainer.getValidatedHtmlReportPath();
                        fileName = namesContainer.getHtmlOutputFilename();
                        filePath = namesContainer.getValidatedHtmlReportPath();
                        createdFilePath = HtmlReport.writeHtml(reportData, htmlPath);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid report format");
                    }
                }
                log.info("Elapsed time serializing " + createdFilePath + ": " + Utilities.formatTimeInterval(System.currentTimeMillis() - startSerialization));
                String reportLocationMsg = lang.txt("APP_REPORT_LOCATION_MSG", createdFilePath);
                Utilities.printAndLogMessage(reportLocationMsg, envCtx, Level.INFO);
                if (!exeCtx.getParsedArgs().isGenZipFile()) continue;
                ZipContributor fileForZip = ZipFileHelper.createZipContributorForFile(fileName, filePath);
                exeCtx.getZipContents().add(fileForZip);
            }
            catch (Exception e) {
                String errorMessage = Utilities.getErrorTextNoAction("ERROR3000", e, new String[0]);
                log.severe(errorMessage, e);
                deferredException = true;
            }
        }
        if (mpackMetrics != null) {
            try {
                OutputFilenamesContainer namesContainer = exeCtx.getOutputFilenamesContainer();
                String csvPath = namesContainer.getValidatedMpackReportPath();
                File csvFile = new File(csvPath);
                FileWriter fileWriter = new FileWriter(csvFile);
                BufferedWriter writer = new BufferedWriter(fileWriter);
                PrintWriter printWriter = new PrintWriter(writer);
                printWriter.write(mpackMetrics.getData());
                printWriter.flush();
                printWriter.close();
                String reportLocationMsg = lang.txt("APP_REPORT_LOCATION_MSG", csvPath);
                Utilities.printAndLogMessage(reportLocationMsg, envCtx, Level.INFO);
            }
            catch (IOException e) {
                log.warning("Something went wrong creating CSV file for MPACK metrics: " + e.getMessage());
            }
        }
        if (deferredException) {
            throw new PremigrationException(Utilities.getErrorText("ERROR3000", new String[0]));
        }
    }

    private static Properties deserializeAnalysisProps(InputStream propFileStream) throws IOException {
        Properties analysisProps = new Properties();
        analysisProps.load(propFileStream);
        for (String key : analysisProps.stringPropertyNames()) {
            String value = analysisProps.getProperty(key);
            String regexFilter = Utilities.getRegexScreenForKey(key);
            if (regexFilter != null) {
                value = value.replaceAll(regexFilter, "").trim();
            }
            analysisProps.setProperty(key, value);
            log.info("Deserialized analysis property '" + key + "' has value '" + value + "'");
        }
        return analysisProps;
    }

    private static String generateMD5(String unhashedString) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(unhashedString.getBytes());
        byte[] digest = md.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : digest) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }
}

