/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.enums;

import com.oracle.premigration.cli.HelpOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public enum MigrationMethod implements HelpOption
{
    ALL,
    DATAPUMP,
    DATAPUMP_DBLINK,
    GOLDENGATE;


    @Override
    public boolean showInHelp() {
        return this != ALL;
    }

    @Override
    public String getHelpName() {
        return this.name().toLowerCase();
    }

    public static List<MigrationMethod> getNormalizedListOfMethods(List<MigrationMethod> migrationMethodList) {
        ArrayList<MigrationMethod> normalizedList;
        if (migrationMethodList.contains(ALL)) {
            normalizedList = new ArrayList<MigrationMethod>(Arrays.asList(MigrationMethod.values()));
            normalizedList.remove(ALL);
        } else {
            normalizedList = new ArrayList<MigrationMethod>(new HashSet<MigrationMethod>(migrationMethodList));
        }
        return normalizedList;
    }
}

