/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.cli.configuration;

import com.oracle.premigration.cli.configuration.ConfigurationFile;
import com.oracle.premigration.cli.configuration.ConfigurationFileMap;
import com.oracle.premigration.cli.configuration.ConfigurationFileNoPrefix;
import com.oracle.premigration.cli.configuration.ConfigurationFilePrefix;
import com.oracle.premigration.cli.configuration.NameSpace;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigurationFileReader {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(ConfigurationFileReader.class.getName());
    public static final String GLOBAL_NAMESPACE = "global";
    private final String configurationFilePath;
    private final ConfigurationFileMap<Map<String, String>> prefixConfigurationFileMap = new ConfigurationFileMap();
    private final ConfigurationFileMap<String> noPrefixConfigurationFileMap = new ConfigurationFileMap();
    private ConfigurationFile<List<NameSpace>> prefixConfigurationFile;
    private ConfigurationFile<String[]> noPrefixConfigurationFile;

    public ConfigurationFileReader(String configurationFilePath) throws PremigrationException {
        this.configurationFilePath = configurationFilePath;
        this.getArgumentsFromFile();
    }

    private void getArgumentsFromFile() throws PremigrationException {
        File configurationFile = new File(this.configurationFilePath);
        try {
            this.sanityChecks(configurationFile);
            this.getParametersFromFile(configurationFile);
            if (this.prefixConfigurationFileMap.isEmpty() || !this.noPrefixConfigurationFileMap.isEmpty()) {
                // empty if block
            }
            if (!this.prefixConfigurationFileMap.isEmpty()) {
                this.prefixConfigurationFile = new ConfigurationFilePrefix();
                this.applyGlobalParameters(this.prefixConfigurationFile);
                for (Map.Entry<String, Map<String, String>> entry : this.prefixConfigurationFileMap.getConfigurationFile().entrySet()) {
                    this.prefixConfigurationFile.addNameSpace(new NameSpace(entry.getKey(), this.convertParameterToArguments(entry.getValue())));
                }
            } else {
                this.noPrefixConfigurationFile = new ConfigurationFileNoPrefix(this.convertParameterToArguments(this.noPrefixConfigurationFileMap.getConfigurationMap()));
            }
        }
        catch (IOException exception) {
            String errorMessage = "Something went wrong reading the configuration file: " + this.configurationFilePath;
            throw new PremigrationException(errorMessage, exception);
        }
    }

    private void sanityChecks(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("Parameter File does not exist.");
        }
        if (!file.isFile()) {
            throw new IOException("Parameter File is not a regular file");
        }
        if (!file.canRead()) {
            throw new IOException("Parameter File is not accessible");
        }
        if (file.length() == 0L) {
            throw new IOException("Parameter File is empty");
        }
    }

    private String[] convertParameterToArguments(Map<String, String> parameters) {
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            String key = entry.getKey();
            String value = entry.getValue();
            if (!"true".equalsIgnoreCase(value)) {
                String[] parts2 = value.split(",");
                values.addAll(Arrays.asList(parts2));
            }
            args.add("--" + key);
            args.addAll(values);
        }
        return args.toArray(new String[0]);
    }

    private void getParametersFromFile(File configFile) throws IOException, PremigrationException {
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String key;
                String[] parts = line.split("=", 2);
                if (parts.length != 2) continue;
                String fullKey = parts[0].trim();
                String value = parts[1].trim();
                String[] keyParts = fullKey.split("\\.", 2);
                if (keyParts.length == 2) {
                    String namespace = keyParts[0];
                    key = keyParts[1];
                    if ("ALL".equalsIgnoreCase(namespace)) {
                        String errorText = Utilities.getErrorText("ERROR5002", new String[0]);
                        throw new PremigrationException(errorText);
                    }
                    this.prefixConfigurationFile(this.prefixConfigurationFileMap, namespace, key, value);
                    continue;
                }
                key = keyParts[0];
                this.noPrefixConfigurationFile(this.noPrefixConfigurationFileMap, key, value);
            }
        }
    }

    private void noPrefixConfigurationFile(ConfigurationFileMap<String> configurationFile, String parameter, String value) {
        configurationFile.addConfiguration(parameter, value);
    }

    private void prefixConfigurationFile(ConfigurationFileMap<Map<String, String>> configurationFile, String namespace, String parameter, String value) {
        Map<String, String> namespaceConfig = !configurationFile.getConfigurationFile().containsKey(namespace) ? new HashMap<String, String>() : configurationFile.getConfigurationFile().get(namespace);
        namespaceConfig.put(parameter, value);
        configurationFile.addConfiguration(namespace, namespaceConfig);
    }

    private void applyGlobalParameters(ConfigurationFile<List<NameSpace>> configFile) {
        String globalNamespace = GLOBAL_NAMESPACE.toLowerCase();
        Map<String, String> globalParameters = configFile.getGlobalParameters();
        configFile.addGlobalParameters(this.prefixConfigurationFileMap.getConfiguration(globalNamespace).orElse(Collections.emptyMap()));
        this.prefixConfigurationFileMap.removeConfiguration(globalNamespace);
        for (Map<String, String> config : this.prefixConfigurationFileMap.getConfigurationFile().values()) {
            for (Map.Entry<String, String> entry : globalParameters.entrySet()) {
                String key = entry.getKey();
                if ("keystore".equalsIgnoreCase(key)) continue;
                config.putIfAbsent(key, entry.getValue());
            }
        }
    }

    public ConfigurationFile<List<NameSpace>> getPrefixConfigurationFile() {
        return this.prefixConfigurationFile;
    }

    public ConfigurationFile<String[]> getNoPrefixConfigurationFile() {
        return this.noPrefixConfigurationFile;
    }
}

