/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.cli.configuration;

import com.oracle.premigration.cli.configuration.ConfigurationFile;
import com.oracle.premigration.cli.configuration.NameSpace;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.exceptions.PremigrationException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConfigurationFilePrefix
extends ConfigurationFile<List<NameSpace>> {
    private final Map<String, String> globalParameters = new HashMap<String, String>();
    private final List<NameSpace> nameSpaceList = new ArrayList<NameSpace>();
    private static final Language lang = Language.getInstance();

    @Override
    public List<NameSpace> getArguments() {
        return this.nameSpaceList;
    }

    @Override
    public void addGlobalParameters(String key, String value) {
        this.globalParameters.put(key, value);
    }

    @Override
    public void addGlobalParameters(Map<String, String> map) {
        this.globalParameters.putAll(map);
    }

    @Override
    public Map<String, String> getGlobalParameters() {
        return this.globalParameters;
    }

    @Override
    public void addNameSpace(NameSpace nameSpace) {
        this.nameSpaceList.add(nameSpace);
    }

    @Override
    public Path getAndValidateKeyStore(String outputPath) throws PremigrationException {
        Path keyStorePath = Optional.ofNullable(this.getKeyStorageValue()).map(x$0 -> Paths.get(x$0, new String[0])).orElse(Paths.get(outputPath, new String[0]));
        if (!Files.exists(keyStorePath, new LinkOption[0])) {
            try {
                Files.createDirectories(keyStorePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PremigrationException(lang.txt("KSM_KEYSTORE_DIR_CREATE_FAILED", keyStorePath), e);
            }
        }
        if (!Files.isReadable(keyStorePath)) {
            throw new PremigrationException(lang.txt("KSM_KEYSTORE_DIR_NOT_READABLE", keyStorePath));
        }
        if (!Files.isWritable(keyStorePath)) {
            throw new PremigrationException(lang.txt("KSM_KEYSTORE_DIR_NOT_READABLE", keyStorePath));
        }
        return keyStorePath;
    }

    private String getKeyStorageValue() {
        return this.isKeyStorage() ? this.globalParameters.get("keystore") : null;
    }

    private boolean isKeyStorage() {
        return Optional.of(this.globalParameters).map(params -> params.containsKey("keystore")).orElse(false);
    }
}

