/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain.completers;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.BICOptions;
import oracle.dbtools.sqlcl.commands.blockchain.BICStubs;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;

public class InstancePosCompleter
implements SemanticCompleter {
    private static final Pattern SPECIAL_CHARACTERS_PATTERN = Pattern.compile("[~!@#$%^&*()_+{}|:\"<>?\\[\\]\\\\;',./\\-]");
    private static final Pattern LOWERCASE_PATTERN = Pattern.compile("[a-z]");
    private static final Pattern UPPERCASE_PATTERN = Pattern.compile("[A-Z]");

    public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
        LinkedList<CompletionItem> ret;
        block7: {
            block6: {
                ret = new LinkedList<CompletionItem>();
                if (!prefix.startsWith("\":") && !prefix.startsWith(":")) break block6;
                ArrayList list = new ArrayList(ctx.getVarMap().keySet());
                for (String l : list) {
                    ret.add(new CompletionItem("\":" + l + "\"", CompletionItem.Type.USER));
                }
                break block7;
            }
            if (!transformedOptionsMap.containsKey(BICOptions.tableName_blockchain_req.getId().toString())) break block7;
            int dotIndex = BICStubs.findUnquotedPeriod((String)transformedOptionsMap.get(BICOptions.tableName_blockchain_req.getId().toString()));
            String schemaName = null;
            Object tableName = null;
            try {
                if (dotIndex == -1) {
                    tableName = InstancePosCompleter.containsRequiredCharacters((String)transformedOptionsMap.get(BICOptions.tableName_blockchain_req.getId().toString())) != false ? "\"" + (String)transformedOptionsMap.get(BICOptions.tableName_blockchain_req.getId().toString()) + "\"" : "'" + (String)transformedOptionsMap.get(BICOptions.tableName_blockchain_req.getId().toString()) + "'";
                    schemaName = ctx.getCurrentConnection().getSchema();
                } else {
                    String tempSchema = (String)transformedOptionsMap.get(BICOptions.tableName_blockchain_req.getId().toString());
                    String tempTable = (String)transformedOptionsMap.get(BICOptions.tableName_blockchain_req.getId().toString());
                    schemaName = InstancePosCompleter.containsRequiredCharacters(tempSchema.substring(0, dotIndex)) != false ? tempSchema.substring(0, dotIndex) : tempSchema.substring(0, dotIndex);
                    tableName = InstancePosCompleter.containsRequiredCharacters(tempTable.substring(dotIndex + 1)) != false ? tempTable.substring(dotIndex + 1, tempTable.length()) : tempTable.substring(dotIndex + 1);
                }
                Statement stmt = ctx.getCurrentConnection().createStatement();
                ResultSet rs = stmt.executeQuery("select distinct ORABCTAB_INST_ID$ from " + schemaName + "." + (String)tableName);
                while (rs.next()) {
                    ret.add(new CompletionItem(rs.getString(1), CompletionItem.Type.USER));
                }
            }
            catch (Throwable e) {
                BICException e1 = new BICException(new String[]{String.format(Messages.getString("BICEXP.COMPLETER_ERROR"), e.getMessage())});
                ctx.writeln(e1.getMessage());
            }
        }
        return ret;
    }

    public static Boolean containsRequiredCharacters(String name) {
        boolean hasSpecialCharacter = SPECIAL_CHARACTERS_PATTERN.matcher(name).find();
        boolean hasLowercase = LOWERCASE_PATTERN.matcher(name).find();
        boolean hasUppercase = UPPERCASE_PATTERN.matcher(name).find();
        if (hasSpecialCharacter || hasLowercase && hasUppercase) {
            return true;
        }
        return false;
    }
}

