/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;

public class BICModel {
    private final Connection connection;
    private final ScriptRunnerContext context;
    private final ISQLCommand command;
    private final ToolLogger toolLogger;
    private final int dbMajorVersion;
    private final int dbMinorVersion;

    public BICModel(Connection connection, ScriptRunnerContext context, ISQLCommand command) throws BICException {
        try {
            this.connection = connection;
            this.context = context;
            this.command = command;
            this.toolLogger = new ToolLogger((OutputStream)context.getOutputStream());
            this.dbMajorVersion = connection.getMetaData().getDatabaseMajorVersion();
            this.dbMinorVersion = connection.getMetaData().getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new BICException(new String[]{e.getMessage()});
        }
        catch (NullPointerException e) {
            throw new BICException(new String[]{Messages.getString("BICEXP.NOT_CONNECTED")});
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ScriptRunnerContext getContext() {
        return this.context;
    }

    public ISQLCommand getCommand() {
        return this.command;
    }

    public ToolLogger getToolLogger() {
        return this.toolLogger;
    }

    public int getDbMajorVersion() {
        return this.dbMajorVersion;
    }

    public int getDbMinorVersion() {
        return this.dbMinorVersion;
    }

    public String getDbVersion() {
        return this.dbMajorVersion + "." + this.dbMinorVersion;
    }
}

