/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.utility;

import java.text.DecimalFormat;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.util.Logger;

public class SimpleByteProgressMonitor
extends TransferTaskProgressMonitor {
    public volatile long written;
    public String target;
    public long max;
    public long start;
    public Long reportByteInterval;
    public volatile long prevReportedByte;
    public volatile long prevReportedTime;
    private DecimalFormat df = new DecimalFormat("#00.0000");

    public SimpleByteProgressMonitor() {
        this((Long)null);
    }

    public SimpleByteProgressMonitor(Long theReportByteInterval) {
        super(null);
        this.reportByteInterval = theReportByteInterval;
        if (null == this.reportByteInterval) {
            this.reportByteInterval = FileInfo.CHUNK_SIZE * 4L;
        }
    }

    @Override
    public void init(int op, String source, String target, long max) {
        this.target = target;
        this.max = max;
        if (this.start == 0L) {
            this.prevReportedTime = this.start = System.nanoTime();
        }
    }

    @Override
    public boolean count(long count) {
        boolean ok = true;
        this.written += count;
        if (this.written >= this.prevReportedByte + this.reportByteInterval) {
            this.logStatus();
        }
        return ok;
    }

    @Override
    public void end() {
        this.logStatus();
    }

    protected void logStatus() {
        long now = System.nanoTime();
        double elapsed = (double)(now - this.prevReportedTime) / 1.0E9;
        long sent = this.written - this.prevReportedByte;
        if (0L == sent) {
            return;
        }
        double size = (double)sent / 1048576.0;
        double rate = size / elapsed;
        double elapsedT = (double)(now - this.start) / 1.0E9;
        double sizeT = (double)this.written / 1048576.0;
        double rateT = sizeT / elapsedT;
        String format = "%s %s + %sMiB / %ss = %s MiB/s Total: %sMiB / %ss = %s MiB/s";
        String msg = String.format(format, Integer.toHexString(this.hashCode()), this.target, this.df.format(size), this.df.format(elapsed), this.df.format(rate), this.df.format(sizeT), this.df.format(elapsedT), this.df.format(rateT));
        this.out(msg);
        this.prevReportedTime = now;
        this.prevReportedByte = this.written;
    }

    protected void out(String msg) {
        Logger.info(this.getClass(), (String)msg);
    }
}

