/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.utility;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.util.Logger;

public class ContentLengthInputStream
extends FilterInputStream {
    private int available;
    private int markLimitPos;
    private int markPos = -1;
    private int pos;

    public ContentLengthInputStream(InputStream in, int length) {
        super(in);
        this.available = length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int retVal = super.read(b, off, len);
        if (retVal < 0) {
            this.available = 0;
        } else {
            this.adjustPos(retVal);
        }
        return retVal;
    }

    @Override
    public long skip(long n) throws IOException {
        long retVal = super.skip(n);
        this.adjustPos(retVal);
        return retVal;
    }

    @Override
    public int available() throws IOException {
        int retVal = super.available();
        if (retVal <= 0) {
            try {
                retVal = this.available;
            }
            catch (Throwable t) {
                Logger.warn(this.getClass(), (Throwable)t);
            }
        }
        return retVal;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.markPos = this.pos;
        this.markLimitPos = this.pos + readlimit;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.adjustPos(this.pos - this.markPos);
        this.markPos = -1;
        this.markLimitPos = 0;
    }

    private void adjustPos(long adjustment) {
        this.pos = (int)((long)this.pos + adjustment);
        this.available = (int)((long)this.available - adjustment);
        if (this.pos > this.markLimitPos) {
            this.markPos = -1;
            this.markLimitPos = 0;
        }
    }
}

