/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands.objectstorage;

import java.io.IOException;
import java.sql.Connection;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.net.commands.objectstorage.ObjectGet;
import oracle.dbtools.net.commands.objectstorage.ObjectPut;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageCommandException;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageMessages;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageModel;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageOptions;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class ObjectStorageCommand
extends ParsedCommandListener {
    protected Type createType() {
        return ObjectStorageOptions.commandType();
    }

    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        Id commandId = parsedCommand.getType().getId();
        if (this.isObjectSubCommand(commandId)) {
            this.handleObjectSubcommand(ctx, parsedCommand, commandId);
        } else if (commandId == ObjectStorageOptions.Symbol.SET) {
            this.handleSetCommand(ctx, parsedCommand);
        } else if (commandId == ObjectStorageOptions.Symbol.OBJECT) {
            ctx.writeln(this.getHelp(ctx, this.helpPath(ObjectStorageOptions.Symbol.OBJECTSTORAGE.getName(), ObjectStorageOptions.Symbol.OBJECT.getName())).orElse(""));
        } else if (commandId == ObjectStorageOptions.Symbol.OBJECTSTORAGE) {
            ctx.writeln(this.getHelp(ctx, this.helpPath(ObjectStorageOptions.Symbol.OBJECTSTORAGE.getName(), new String[0])).orElse(""));
        } else {
            ctx.writeln(this.getHelp(ctx, this.helpPath(ObjectStorageOptions.Symbol.OBJECTSTORAGE.getName(), new String[0])).orElse(""));
        }
        return true;
    }

    private void handleObjectSubcommand(ScriptRunnerContext ctx, ParsedCommand parsedCommand, Id subCommand) {
        OCIProfile profile = this.getProfile(ctx);
        if (profile == null) {
            return;
        }
        ObjectStorageModel model = new ObjectStorageModel(ctx, parsedCommand, profile);
        if (subCommand == ObjectStorageOptions.Symbol.GET) {
            this.objectGetCommand(model);
        } else if (subCommand == ObjectStorageOptions.Symbol.PUT) {
            this.objectPutCommand(model);
        } else if (subCommand == ObjectStorageOptions.Symbol.LIST) {
            this.objectListCommand(model);
        } else if (subCommand == ObjectStorageOptions.Symbol.DELETE) {
            this.objectDeleteCommand(model);
        }
    }

    private void handleSetCommand(ScriptRunnerContext ctx, ParsedCommand parsedCommand) {
        String param = (String)parsedCommand.getParameterValue((Id)ObjectStorageOptions.Symbol.GLOBAL_OPTION);
        String value = (String)parsedCommand.getParameterValue((Id)ObjectStorageOptions.Symbol.VALUE);
        if (param != null && value != null) {
            if (ObjectStorageOptions.Symbol.NAMESPACE.getName().equalsIgnoreCase(param)) {
                ctx.putProperty("oci.namespace.name", (Object)value);
            } else if (ObjectStorageOptions.Symbol.BUCKET_NAME.getName().equalsIgnoreCase(param)) {
                ctx.putProperty("oci.bucket.name", (Object)value);
            } else {
                ctx.writeln(ObjectStorageMessages.get("ERR_SET_PARAMETER"));
            }
        } else {
            ctx.writeln(ObjectStorageMessages.get("ERR_SET_PARAMETER"));
        }
    }

    private void objectDeleteCommand(ObjectStorageModel model) {
    }

    private void objectGetCommand(ObjectStorageModel model) {
        try {
            new ObjectGet(model).execute();
        }
        catch (ObjectStorageCommandException oe) {
            model.context().writeln(oe.getLocalizedMessage());
        }
    }

    private void objectListCommand(ObjectStorageModel model) {
    }

    private void objectPutCommand(ObjectStorageModel model) {
        try {
            new ObjectPut(model).execute();
        }
        catch (ObjectStorageCommandException oe) {
            model.context().writeln(oe.getLocalizedMessage());
        }
    }

    private OCIProfile getProfile(ScriptRunnerContext ctx) {
        OCIProfiles profiles = null;
        try {
            OCIProfiles.Builder builder = OCIProfiles.builder();
            profiles = builder.build();
            String profileName = (String)ctx.getProperty("oci.profile.name");
            OCIProfile profile = null;
            if (profileName != null) {
                profile = profiles.getProfile(profileName);
                if (profile != null) {
                    return profile;
                }
                ctx.writeln(ObjectStorageMessages.format("ERR_PROFILE_NOT_EXIST", profileName));
            }
        }
        catch (IOException e) {
            ctx.writeln(e.getLocalizedMessage());
        }
        return null;
    }

    private boolean isObjectSubCommand(Id subCommand) {
        return subCommand == ObjectStorageOptions.Symbol.GET || subCommand == ObjectStorageOptions.Symbol.PUT || subCommand == ObjectStorageOptions.Symbol.LIST || subCommand == ObjectStorageOptions.Symbol.DELETE;
    }

    private String helpPath(String baseType, String ... objTypes) {
        if (baseType != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(baseType);
            if (objTypes != null) {
                for (String objType : objTypes) {
                    sb.append("/").append(objType);
                }
            }
            return sb.toString();
        }
        return null;
    }

    public String getDescription() {
        return "The OBJECTSTORAGE command provides interaction with OCI Object Storage Services";
    }
}

