/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands.completers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dbtools.core.oci.OCICompartment;
import oracle.dbtools.core.oci.OCIIdentityClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;

public class CompartmentPathMapper {
    public static final String PATH_SEPARATOR = "/";
    private final Map<String, Map<String, List<OCICompartment>>> compartments = new ConcurrentHashMap<String, Map<String, List<OCICompartment>>>();

    private List<OCICompartment> listCompartments(OCIProfile profile, String parentCompartmentId) {
        String profileName = profile.getAuthenticationProperty("ProfileName");
        Map compartment = this.compartments.computeIfAbsent(profileName, unused -> new ConcurrentHashMap());
        OCIIdentityClient client = OCIIdentityClient.builder((OCIProfile)profile).build();
        return compartment.computeIfAbsent(parentCompartmentId, ocid -> this.fetchAllChildCompartments(client, (String)ocid));
    }

    private List<OCICompartment> fetchAllChildCompartments(OCIIdentityClient client, String compartmentId) {
        return new ArrayList<OCICompartment>(client.getCompartmentMap(compartmentId).values());
    }

    public Optional<String> pathToOcid(OCIProfile profile, String path) throws IOException {
        String[] paths;
        String currentCompartmentId = profile.getTenantId();
        if (path == null || path.isBlank()) {
            return Optional.of(currentCompartmentId);
        }
        for (String name : paths = path.split(PATH_SEPARATOR)) {
            List<OCICompartment> children = this.listCompartments(profile, currentCompartmentId);
            Optional<OCICompartment> match = children.stream().filter(c -> c.getDisplayName().equals(name)).findFirst();
            if (match.isEmpty()) {
                return Optional.empty();
            }
            currentCompartmentId = match.get().getResourceId();
        }
        return Optional.of(currentCompartmentId);
    }

    public String ocidToPath(String profileName, String compartmentId) throws IOException {
        OCIProfile profile = OCIProfiles.builder().build().getProfile(profileName);
        if (profile == null) {
            throw new NoSuchElementException("no profile found");
        }
        OCIIdentityClient client = OCIIdentityClient.builder((OCIProfile)profile).build();
        LinkedList<String> path = new LinkedList<String>();
        String currentOcid = compartmentId;
        while (!currentOcid.equals(profile.getTenantId())) {
            OCICompartment compartment = (OCICompartment)client.getCompartmentMap().get(currentOcid);
            path.add(0, compartment.getDisplayName());
            currentOcid = compartment.getCompartmentID();
            if (currentOcid != null && !currentOcid.isEmpty()) continue;
            throw new IllegalStateException("Compartment has no parent: " + compartment.getResourceId());
        }
        return String.join((CharSequence)PATH_SEPARATOR, path);
    }
}

