/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands.completers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.core.oci.OCICompartment;
import oracle.dbtools.core.oci.OCIIdentityClient;
import oracle.dbtools.core.oci.OCIObject;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.net.commands.completers.CompartmentPathMapper;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.util.Logger;

public class CompartmentCompleter
implements SemanticCompleter {
    private final Function<OCICompartment, String> mapper;
    private final CompartmentPathMapper compartmentPathMapper;

    protected CompartmentCompleter(Function<OCICompartment, String> mapper, CompartmentPathMapper compartmentMapper) {
        this.mapper = mapper;
        this.compartmentPathMapper = compartmentMapper;
    }

    public static CompartmentCompleter ofDisplayNames() {
        return new CompartmentCompleter(OCIObject::getDisplayName, new CompartmentPathMapper());
    }

    public static CompartmentCompleter ofDisplayNames(CompartmentPathMapper compartmentPathMapper) {
        return new CompartmentCompleter(OCIObject::getDisplayName, compartmentPathMapper);
    }

    public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
        ArrayList<CompletionItem> vals = new ArrayList<CompletionItem>();
        try {
            String profileName = ctx.getStringProperty("oci.profile.name", null);
            OCIProfile profile = this.getProfile(null, profileName);
            if (profile != null) {
                OCIIdentityClient client = OCIIdentityClient.builder((OCIProfile)profile).build();
                Optional<String> parentCompartmentId = this.compartmentPathMapper.pathToOcid(profile, prefix);
                parentCompartmentId.ifPresent(id -> client.getCompartmentMap(id).values().stream().map(this.mapper).map(c -> new CompletionItem((!prefix.isBlank() ? prefix : "") + c + "/", CompletionItem.Type.KEYWORD)).forEach(vals::add));
            }
        }
        catch (IOException | RuntimeException e) {
            Logger.warn(this.getClass(), (String)e.getMessage(), (Throwable)e);
        }
        return vals;
    }

    public OCIProfile getProfile(String configPath, String profileName) throws IOException {
        OCIProfiles.Builder builder = OCIProfiles.builder();
        if (configPath != null) {
            builder.configPath(configPath);
        }
        OCIProfiles profiles = builder.build();
        return profiles.getProfile(profileName);
    }
}

