/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import java.io.InputStream;
import java.util.function.Supplier;
import oracle.dbtools.core.collections.ConfigurationProperties;

public class OverrideAuthenticationDetailsProvider
implements AuthenticationDetailsProvider {
    private final ConfigurationProperties overrides;
    private final AuthenticationDetailsProvider delegate;

    public static OverrideAuthenticationDetailsProvider of(ConfigurationProperties props, AuthenticationDetailsProvider delegate) {
        return new OverrideAuthenticationDetailsProvider(props, delegate);
    }

    private OverrideAuthenticationDetailsProvider(ConfigurationProperties props, AuthenticationDetailsProvider delegate) {
        ConfigurationProperties.Builder propsBuilder = ConfigurationProperties.builder();
        props.forEach((k, v) -> propsBuilder.put(k, v));
        this.overrides = propsBuilder.build();
        this.delegate = delegate;
    }

    private String getValue(String key, Supplier<String> supplier) {
        String value = this.overrides.getProperty((CharSequence)key);
        return value != null ? value : supplier.get();
    }

    public String getFingerprint() {
        return this.delegate.getFingerprint();
    }

    public String getTenantId() {
        return this.getValue("ociTenancy", () -> ((AuthenticationDetailsProvider)this.delegate).getTenantId());
    }

    public String getUserId() {
        return this.delegate.getUserId();
    }

    public String getKeyId() {
        return this.delegate.getKeyId();
    }

    public InputStream getPrivateKey() {
        return this.delegate.getPrivateKey();
    }

    public String getPassPhrase() {
        return this.delegate.getPassPhrase();
    }

    public char[] getPassphraseCharacters() {
        return this.delegate.getPassphraseCharacters();
    }
}

