/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal;

import com.oracle.bmc.objectstorage.transfer.internal.CRC32C;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class CRC32CDigest
extends MessageDigest {
    private final CRC32C crc32c = new CRC32C();

    public CRC32CDigest() {
        super("CRC32C");
    }

    @Override
    protected void engineUpdate(byte input) {
        this.crc32c.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.crc32c.update(input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        long crcValue = this.crc32c.getValue();
        byte[] crcBytes = ByteBuffer.allocate(4).putInt((int)crcValue).array();
        this.engineReset();
        return crcBytes;
    }

    @Override
    protected void engineReset() {
        this.crc32c.reset();
    }
}

