/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.datapump.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.extension.datapump.common.DataPumpOption;

public class DataPumpOptions {
    public static final String COLUMNENCRYPTION = "columnencryption";
    public static final String COLUMNENCRYPTION_S = "ce";
    public static final String COMPRESSION = "compression";
    public static final String COMPRESSION_S = "cm";
    public static final String COPYCLOUD = "copycloud";
    public static final String COPYCLOUD_S = "cc";
    public static final String CREDENTIAL = "credential";
    public static final String CREDENTIAL_S = "c";
    public static final String DATAPUMP = "datapump";
    public static final String DATAPUMP_S = "dp";
    public static final String DATAACCESSMETHOD = "dataaccessmethod";
    public static final String DEBUG = "debug";
    public static final String DEBUG_S = "de";
    public static final String DIRECTORY = "directory";
    public static final String DIRECTORY_S = "d";
    public static final String DUMPDIRECTORY = "dumpdirectory";
    public static final String DUMPDIRECTORY_S = "dd";
    public static final String DUMPFILE = "dumpfile";
    public static final String DUMPFILE_S = "f";
    public static final String DUMPURI = "dumpuri";
    public static final String DUMPURI_S = "u";
    public static final String DWCSCVTIOTS = "dwcscvtiots";
    public static final String DWCSCVTCONSTRAINTS = "dwcscvtconstraints";
    public static final String ENCRYPTION = "encryption";
    public static final String ENCRYPTION_S = "en";
    public static final String ENCRYPTIONALGORITHM = "encryptionalgorithm";
    public static final String ENCRYPTIONALGORITHM_S = "ena";
    public static final String ENCRYPTIONMODE = "encryptionmode";
    public static final String ENCRYPTIONMODE_S = "enm";
    public static final String ENCRYPTIONPASSWORD = "encryptionpassword";
    public static final String ENCRYPTIONPASSWORD_S = "enp";
    public static final String ESTIMATE = "estimate";
    public static final String ESTIMATE_S = "e";
    public static final String EXCLUDEDWCS = "excludedwcs";
    public static final String EXAMPLES = "examples";
    public static final String EXCLUDEEXPR = "excludeexpr";
    public static final String EXCLUDEEXPR_S = "ex";
    public static final String EXCLUDELIST = "excludelist";
    public static final String EXCLUDELIST_S = "el";
    public static final String EXPORT = "export";
    public static final String FILESIZE = "filesize";
    public static final String FILESIZE_S = "fs";
    public static final String FLASHBACKSCN = "flashbackscn";
    public static final String FLASHBACKSCN_S = "fb";
    public static final String HELP = "help";
    public static final String IMPORT = "import";
    public static final String INCLUDEEXPR = "includeexpr";
    public static final String INCLUDEEXPR_S = "ix";
    public static final String INCLUDELIST = "includelist";
    public static final String INCLUDELIST_S = "il";
    public static final String INCLUDEMETADATA = "includemetadata";
    public static final String INCLUDEMETADATA_S = "im";
    public static final String INCLUDEROWS = "includerows";
    public static final String INCLUDEROWS_S = "ir";
    public static final String JOBMODE = "jobmode";
    public static final String JOBNAME = "jobname";
    public static final String JOBNAME_S = "j";
    public static final String KEEPMASTER = "keepmaster";
    public static final String KEEPMASTER_S = "k";
    public static final String LOGDIRECTORY = "logdirectory";
    public static final String LOGDIRECTORY_S = "ld";
    public static final String LOGFILE = "logfile";
    public static final String LOGFILE_S = "lf";
    public static final String NAMEEXPR = "nameexpr";
    public static final String NAMEEXPR_S = "nx";
    public static final String NAMELIST = "namelist";
    public static final String NAMELIST_S = "nl";
    public static final String NOEXEC = "noexec";
    public static final String NOEXEC_S = "ne";
    public static final String OBJECTID = "objectid";
    public static final String OBJECTID_S = "oid";
    public static final String OPERATION = "operation";
    public static final String PARALLEL = "parallel";
    public static final String PARALLEL_S = "p";
    public static final String PARTITIONOPTIONS = "partitionoptions";
    public static final String REMAPSCHEMAS = "remapschemas";
    public static final String REMAPSCHEMAS_S = "rs";
    public static final String REMAPTABLESPACES = "remaptablespaces";
    public static final String REMAPTABLESPACES_S = "rt";
    public static final String REUSEFILE = "reusefile";
    public static final String REUSEFILE_S = "r";
    public static final String SCHEMAS = "schemas";
    public static final String SCHEMAS_S = "s";
    public static final String SEGMENTATTRIBUTES = "segmentattributes";
    public static final String SEGMENTATTRIBUTES_S = "sa";
    public static final String SKIPUNUSABLEINDEXES = "skipunusableindexes";
    public static final String SKIPUNUSABLEINDEXES_S = "sui";
    public static final String STORAGE = "storage";
    public static final String STORAGE_S = "st";
    public static final String SYNTAX = "syntax";
    public static final String TABLEEXISTS = "tableexists";
    public static final String TABLEEXISTS_S = "te";
    public static final String TRACE = "trace";
    public static final String TABLECOMPRESSION = "tablecompression";
    public static final String TABLECOMPRESSION_S = "tc";
    public static final String VERBOSE = "verbose";
    public static final String VERBOSE_S = "ve";
    public static final String VERSION = "version";
    public static final String VERSION_S = "v";
    public static final String WAIT = "wait";
    public static final String WAIT_S = "w";
    public static final String GEN_BOOL_FALSE = "s";
    public static final String GEN_BOOL_TRUE = "t";
    public static final ArrayList<String> subCommands = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(DataPumpOptions.EXAMPLES);
            this.add(DataPumpOptions.EXPORT);
            this.add(DataPumpOptions.HELP);
            this.add(DataPumpOptions.IMPORT);
            this.add(DataPumpOptions.SYNTAX);
        }
    };
    public static final ArrayList<String> setSubCommands = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(DataPumpOptions.EXAMPLES);
            this.add(DataPumpOptions.HELP);
            this.add(DataPumpOptions.DATAPUMP);
            this.add(DataPumpOptions.DATAPUMP_S);
            this.add(DataPumpOptions.SYNTAX);
        }
    };
    public static final HashMap<String, String> coreOptions = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DataPumpOptions.COLUMNENCRYPTION, "BooleanFlagValidator");
            this.put(DataPumpOptions.COLUMNENCRYPTION_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.COMPRESSION, "StringValidator");
            this.put(DataPumpOptions.COMPRESSION_S, "StringValidator");
            this.put(DataPumpOptions.COPYCLOUD, "BooleanFlagValidator");
            this.put(DataPumpOptions.COPYCLOUD_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.CREDENTIAL, "StringValidator");
            this.put(DataPumpOptions.CREDENTIAL_S, "StringValidator");
            this.put(DataPumpOptions.DEBUG, "BooleanFlagValidator");
            this.put(DataPumpOptions.DEBUG_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.DIRECTORY, "StringValidator");
            this.put(DataPumpOptions.DIRECTORY_S, "StringValidator");
            this.put(DataPumpOptions.DUMPDIRECTORY, "StringValidator");
            this.put(DataPumpOptions.DUMPDIRECTORY_S, "StringValidator");
            this.put(DataPumpOptions.DUMPFILE, "StringValidator");
            this.put(DataPumpOptions.DUMPFILE_S, "StringValidator");
            this.put(DataPumpOptions.DUMPURI, "StringOrNullValidator");
            this.put(DataPumpOptions.DUMPURI_S, "StringOrNullValidator");
            this.put(DataPumpOptions.ENCRYPTION, "StringValidator");
            this.put(DataPumpOptions.ENCRYPTION_S, "StringValidator");
            this.put(DataPumpOptions.ENCRYPTIONALGORITHM, "StringValidator");
            this.put(DataPumpOptions.ENCRYPTIONALGORITHM_S, "StringValidator");
            this.put(DataPumpOptions.ENCRYPTIONMODE, "StringValidator");
            this.put(DataPumpOptions.ENCRYPTIONMODE_S, "StringValidator");
            this.put(DataPumpOptions.ENCRYPTIONPASSWORD, "StringOrNullValidator");
            this.put(DataPumpOptions.ENCRYPTIONPASSWORD_S, "StringOrNullValidator");
            this.put(DataPumpOptions.EXCLUDEEXPR, "StringValidator");
            this.put(DataPumpOptions.EXCLUDEEXPR_S, "StringValidator");
            this.put(DataPumpOptions.EXCLUDELIST, "StringValidator");
            this.put(DataPumpOptions.EXCLUDELIST_S, "StringValidator");
            this.put(DataPumpOptions.ESTIMATE, "StringValidator");
            this.put(DataPumpOptions.ESTIMATE_S, "StringValidator");
            this.put(DataPumpOptions.FILESIZE, "StringValidator");
            this.put(DataPumpOptions.FILESIZE_S, "StringValidator");
            this.put(DataPumpOptions.FLASHBACKSCN, "BooleanFlagValidator");
            this.put(DataPumpOptions.FLASHBACKSCN_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.HELP, "NullValidator");
            this.put(DataPumpOptions.INCLUDEEXPR, "StringValidator");
            this.put(DataPumpOptions.INCLUDEEXPR_S, "StringValidator");
            this.put(DataPumpOptions.INCLUDELIST, "StringValidator");
            this.put(DataPumpOptions.INCLUDELIST_S, "StringValidator");
            this.put(DataPumpOptions.INCLUDEMETADATA, "BooleanFlagValidator");
            this.put(DataPumpOptions.INCLUDEMETADATA_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.INCLUDEROWS, "BooleanFlagValidator");
            this.put(DataPumpOptions.INCLUDEROWS_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.JOBNAME, "StringValidator");
            this.put(DataPumpOptions.JOBNAME_S, "StringValidator");
            this.put(DataPumpOptions.KEEPMASTER, "BooleanFlagValidator");
            this.put(DataPumpOptions.KEEPMASTER_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.LOGDIRECTORY, "StringValidator");
            this.put(DataPumpOptions.LOGDIRECTORY_S, "StringValidator");
            this.put(DataPumpOptions.LOGFILE, "StringValidator");
            this.put(DataPumpOptions.LOGFILE_S, "StringValidator");
            this.put(DataPumpOptions.NAMEEXPR, "StringValidator");
            this.put(DataPumpOptions.NAMEEXPR_S, "StringValidator");
            this.put(DataPumpOptions.NAMELIST, "StringValidator");
            this.put(DataPumpOptions.NAMELIST_S, "StringValidator");
            this.put(DataPumpOptions.NOEXEC, "BooleanFlagValidator");
            this.put(DataPumpOptions.NOEXEC_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.OBJECTID, "BooleanFlagValidator");
            this.put(DataPumpOptions.OBJECTID_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.PARALLEL, "IntegerValidator");
            this.put(DataPumpOptions.PARALLEL_S, "IntegerValidator");
            this.put(DataPumpOptions.REMAPSCHEMAS, "StringListValidator");
            this.put(DataPumpOptions.REMAPSCHEMAS_S, "StringListValidator");
            this.put(DataPumpOptions.REMAPTABLESPACES, "StringListValidator");
            this.put(DataPumpOptions.REMAPTABLESPACES_S, "StringListValidator");
            this.put(DataPumpOptions.REUSEFILE, "BooleanFlagValidator");
            this.put(DataPumpOptions.REUSEFILE_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.SCHEMAS, "StringListValidator");
            this.put("s", "StringListValidator");
            this.put(DataPumpOptions.SEGMENTATTRIBUTES, "BooleanFlagValidator");
            this.put(DataPumpOptions.SEGMENTATTRIBUTES_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.SKIPUNUSABLEINDEXES, "BooleanFlagValidator");
            this.put(DataPumpOptions.SKIPUNUSABLEINDEXES_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.STORAGE, "BooleanFlagValidator");
            this.put(DataPumpOptions.STORAGE_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.TABLEEXISTS, "StringValidator");
            this.put(DataPumpOptions.TABLEEXISTS_S, "StringValidator");
            this.put(DataPumpOptions.TABLECOMPRESSION, "BooleanFlagValidator");
            this.put(DataPumpOptions.TABLECOMPRESSION_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.VERBOSE, "BooleanFlagValidator");
            this.put(DataPumpOptions.VERBOSE_S, "BooleanFlagValidator");
            this.put(DataPumpOptions.VERSION, "StringValidator");
            this.put(DataPumpOptions.VERSION_S, "StringValidator");
            this.put(DataPumpOptions.WAIT, "BooleanFlagValidator");
            this.put(DataPumpOptions.WAIT_S, "BooleanFlagValidator");
            this.put("dummy", "DummyValidator");
        }
    };
    public static final HashMap<String, DataPumpOption> options = new HashMap<String, DataPumpOption>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DataPumpOptions.COLUMNENCRYPTION, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "OMIT_ENCRYPTION_CLAUSE", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpOptions.COMPRESSION, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "COMPRESSION", DataPumpOption.ParameterType.STRING, null, COMPRESSION_VALUES.class));
            this.put(DataPumpOptions.COPYCLOUD, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.UNKNOWN, "COPYCLOUD", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpOptions.CREDENTIAL, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "CREDENTIAL", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.DATAACCESSMETHOD, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.PARAMETER, "DATA_ACCESS_METHOD"));
            this.put(DataPumpOptions.DEBUG, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.UNKNOWN, "DEBUG", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpOptions.DIRECTORY, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "DIRECTORY", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.DUMPDIRECTORY, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "DIRECTORY", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.DUMPFILE, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "FILENAME", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.DUMPURI, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "FILENAME", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.DWCSCVTIOTS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "DWCS_CVT_IOTS", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpOptions.DWCSCVTCONSTRAINTS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "DWCS_CVT_CONSTRAINTS", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpOptions.ENCRYPTION, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "ENCRYPTION", DataPumpOption.ParameterType.STRING, null, ENCRYPTION_VALUES.class));
            this.put(DataPumpOptions.ENCRYPTIONALGORITHM, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "ENCRYPTION_ALGORITHM", DataPumpOption.ParameterType.STRING, null, ENCRYPTIONALGORITHM_VALUES.class));
            this.put(DataPumpOptions.ENCRYPTIONMODE, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "ENCRYPTION_MODE", DataPumpOption.ParameterType.STRING, null, ENCRYPTIONMODE_VALUES.class));
            this.put(DataPumpOptions.ENCRYPTIONPASSWORD, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.PARAMETER, "ENCRYPTION_PASSWORD", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.ESTIMATE, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "ESTIMATE", DataPumpOption.ParameterType.STRING, null, ESTIMATE_VALUES.class));
            this.put(DataPumpOptions.EXCLUDEEXPR, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "EXCLUDE_PATH_EXPR", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.EXCLUDELIST, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "EXCLUDE_PATH_LIST", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.EXCLUDEDWCS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.FILTER, "EXCLUDE_PATH_EXPR", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.FILESIZE, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.FILE, "FILESIZE", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.FLASHBACKSCN, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "FLASHBACK_SCN", DataPumpOption.ParameterType.PLSQL));
            this.put(DataPumpOptions.HELP, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.UNKNOWN, "HELP"));
            this.put(DataPumpOptions.IMPORT, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.UNKNOWN, "IMPORT"));
            this.put(DataPumpOptions.INCLUDEEXPR, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "INCLUDE_PATH_EXPR", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.INCLUDELIST, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "INCLUDE_PATH_LIST", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.INCLUDEMETADATA, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.PARAMETER, "INCLUDE_METADATA", DataPumpOption.ParameterType.BOOLEAN, "s"));
            this.put(DataPumpOptions.INCLUDEROWS, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.DATA_FILTER, "INCLUDE_ROWS", DataPumpOption.ParameterType.BOOLEAN, "s"));
            this.put(DataPumpOptions.JOBNAME, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.START, "JOBNAME", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.JOBMODE, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.OPEN, "JOB_MODE", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.KEEPMASTER, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.PARAMETER, "KEEP_MASTER", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpOptions.LOGDIRECTORY, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "DIRECTORY", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.LOGFILE, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "FILENAME", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.NAMEEXPR, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "NAME_EXPR", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.NAMELIST, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "NAME_LIST", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.NOEXEC, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.UNKNOWN, "NOEXEC", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpOptions.OBJECTID, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "OID", DataPumpOption.ParameterType.BOOLEAN, "s"));
            this.put(DataPumpOptions.OPERATION, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.OPEN, "OPERATION", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.PARALLEL, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.PARALLEL, "PARALLEL", DataPumpOption.ParameterType.NUMBER));
            this.put(DataPumpOptions.PARTITIONOPTIONS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.PARAMETER, "PARTITION_OPTIONS"));
            this.put(DataPumpOptions.REMAPSCHEMAS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.REMAP, "REMAP_SCHEMA", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.REMAPTABLESPACES, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.REMAP, "REMAP_TABLESPACE", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.REUSEFILE, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.FILE, "REUSEFILE", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpOptions.SCHEMAS, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "SCHEMA_EXPR", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.SEGMENTATTRIBUTES, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "SEGMENT_ATTRIBUTES", DataPumpOption.ParameterType.BOOLEAN, "s"));
            this.put(DataPumpOptions.SKIPUNUSABLEINDEXES, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.PARAMETER, "SKIP_UNUSABLE_INDEXES", DataPumpOption.ParameterType.BOOLEAN, null));
            this.put(DataPumpOptions.STORAGE, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "STORAGE", DataPumpOption.ParameterType.BOOLEAN, "s"));
            this.put(DataPumpOptions.TABLEEXISTS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.PARAMETER, "TABLE_EXISTS_ACTION", DataPumpOption.ParameterType.STRING, null, TABLEEXISTS_VALUES.class));
            this.put(DataPumpOptions.TABLECOMPRESSION, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "TABLE_COMPRESSION_CLAUSE", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.TRACE, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.PARAMETER, "TRACE", DataPumpOption.ParameterType.NUMBER));
            this.put(DataPumpOptions.VERBOSE, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.UNKNOWN, "VERBOSE", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpOptions.VERSION, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.OPEN, "VERSION", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpOptions.WAIT, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.WAIT, "WAIT", DataPumpOption.ParameterType.BOOLEAN));
        }
    };
    public static final HashMap<String, String> aliases = new HashMap<String, String>(){
        {
            this.put(DataPumpOptions.COLUMNENCRYPTION_S, DataPumpOptions.COLUMNENCRYPTION);
            this.put(DataPumpOptions.COMPRESSION_S, DataPumpOptions.COMPRESSION);
            this.put(DataPumpOptions.COPYCLOUD_S, DataPumpOptions.COPYCLOUD);
            this.put(DataPumpOptions.CREDENTIAL_S, DataPumpOptions.CREDENTIAL);
            this.put(DataPumpOptions.DEBUG_S, DataPumpOptions.DEBUG);
            this.put(DataPumpOptions.DIRECTORY_S, DataPumpOptions.DIRECTORY);
            this.put(DataPumpOptions.DUMPDIRECTORY_S, DataPumpOptions.DUMPDIRECTORY);
            this.put(DataPumpOptions.DUMPFILE_S, DataPumpOptions.DUMPFILE);
            this.put(DataPumpOptions.DUMPURI_S, DataPumpOptions.DUMPURI);
            this.put(DataPumpOptions.ENCRYPTION_S, DataPumpOptions.ENCRYPTION);
            this.put(DataPumpOptions.ENCRYPTIONALGORITHM_S, DataPumpOptions.ENCRYPTIONALGORITHM);
            this.put(DataPumpOptions.ENCRYPTIONMODE_S, DataPumpOptions.ENCRYPTIONMODE);
            this.put(DataPumpOptions.ENCRYPTIONPASSWORD_S, DataPumpOptions.ENCRYPTIONPASSWORD);
            this.put(DataPumpOptions.ESTIMATE_S, DataPumpOptions.ESTIMATE);
            this.put(DataPumpOptions.EXCLUDEEXPR_S, DataPumpOptions.EXCLUDEEXPR);
            this.put(DataPumpOptions.EXCLUDELIST_S, DataPumpOptions.EXCLUDELIST);
            this.put(DataPumpOptions.FILESIZE_S, DataPumpOptions.FILESIZE);
            this.put(DataPumpOptions.FLASHBACKSCN_S, DataPumpOptions.FLASHBACKSCN);
            this.put(DataPumpOptions.INCLUDEEXPR_S, DataPumpOptions.INCLUDEEXPR);
            this.put(DataPumpOptions.INCLUDELIST_S, DataPumpOptions.INCLUDELIST);
            this.put(DataPumpOptions.INCLUDEMETADATA_S, DataPumpOptions.INCLUDEMETADATA);
            this.put(DataPumpOptions.INCLUDEROWS_S, DataPumpOptions.INCLUDEROWS);
            this.put(DataPumpOptions.JOBNAME_S, DataPumpOptions.JOBNAME);
            this.put(DataPumpOptions.KEEPMASTER_S, DataPumpOptions.KEEPMASTER);
            this.put(DataPumpOptions.LOGDIRECTORY_S, DataPumpOptions.LOGDIRECTORY);
            this.put(DataPumpOptions.LOGFILE_S, DataPumpOptions.LOGFILE);
            this.put(DataPumpOptions.NAMEEXPR_S, DataPumpOptions.NAMEEXPR);
            this.put(DataPumpOptions.NAMELIST_S, DataPumpOptions.NAMELIST);
            this.put(DataPumpOptions.OBJECTID_S, DataPumpOptions.OBJECTID);
            this.put(DataPumpOptions.PARALLEL_S, DataPumpOptions.PARALLEL);
            this.put(DataPumpOptions.NOEXEC_S, DataPumpOptions.NOEXEC);
            this.put(DataPumpOptions.REMAPSCHEMAS_S, DataPumpOptions.REMAPSCHEMAS);
            this.put(DataPumpOptions.REUSEFILE_S, DataPumpOptions.REUSEFILE);
            this.put(DataPumpOptions.REMAPTABLESPACES_S, DataPumpOptions.REMAPTABLESPACES);
            this.put("s", DataPumpOptions.SCHEMAS);
            this.put(DataPumpOptions.SEGMENTATTRIBUTES_S, DataPumpOptions.SEGMENTATTRIBUTES);
            this.put(DataPumpOptions.STORAGE_S, DataPumpOptions.STORAGE);
            this.put(DataPumpOptions.SKIPUNUSABLEINDEXES_S, DataPumpOptions.SKIPUNUSABLEINDEXES);
            this.put(DataPumpOptions.TABLEEXISTS_S, DataPumpOptions.TABLEEXISTS);
            this.put(DataPumpOptions.TABLECOMPRESSION_S, DataPumpOptions.TABLECOMPRESSION);
            this.put(DataPumpOptions.VERBOSE_S, DataPumpOptions.VERBOSE);
            this.put(DataPumpOptions.VERSION_S, DataPumpOptions.VERSION);
            this.put(DataPumpOptions.WAIT_S, DataPumpOptions.WAIT);
        }
    };

    public static void setArgumentDefaults(Map<String, Object> args) {
        args.put(COLUMNENCRYPTION, "TRUE");
        args.put(COPYCLOUD, "FALSE");
        args.put(DEBUG, "FALSE");
        args.put(DIRECTORY, "DATA_PUMP_DIR");
        args.put(FILESIZE, "500MB");
        args.put(INCLUDEMETADATA, "TRUE");
        args.put(INCLUDEROWS, "TRUE");
        args.put(JOBMODE, "SCHEMA");
        args.put(KEEPMASTER, "TRUE");
        args.put(NOEXEC, "FALSE");
        args.put(REUSEFILE, "TRUE");
        args.put(VERBOSE, "FALSE");
        args.put(VERSION, "COMPATIBLE");
        args.put(TABLECOMPRESSION, "TRUE");
        args.put(WAIT, "TRUE");
    }

    public static DataPumpOption getOption(String key) {
        String aKey;
        String lKey = key.toLowerCase();
        DataPumpOption opt = options.get(lKey);
        if (opt == null && (aKey = aliases.get(lKey)) != null) {
            return options.get(aKey);
        }
        return opt;
    }

    public static String getName(String nameOrAlias) {
        if (options.get(nameOrAlias) != null) {
            return nameOrAlias;
        }
        return aliases.get(nameOrAlias);
    }

    public static Map<String, DataPumpOption> getOptions() {
        return options;
    }

    public static Map<String, DataPumpOption> getOptions(DataPumpOption.Operation operation) {
        HashMap<String, DataPumpOption> opts = new HashMap<String, DataPumpOption>();
        for (Map.Entry<String, DataPumpOption> entry : options.entrySet()) {
            DataPumpOption opt = entry.getValue();
            if (opt.getOperation() != operation && opt.getOperation() != DataPumpOption.Operation.BOTH) continue;
            opts.put(entry.getKey(), entry.getValue());
        }
        return opts;
    }

    public static Map<String, DataPumpOption> getOptions(DataPumpOption.Operation operation, DataPumpOption.SubProgram subProgram) {
        HashMap<String, DataPumpOption> opts = new HashMap<String, DataPumpOption>();
        for (Map.Entry<String, DataPumpOption> entry : options.entrySet()) {
            DataPumpOption opt = entry.getValue();
            if (opt.getSubProgram() != subProgram || opt.getOperation() != operation && opt.getOperation() != DataPumpOption.Operation.BOTH) continue;
            opts.put(entry.getKey(), entry.getValue());
        }
        return opts;
    }

    public static Map<String, DataPumpOption> getGenBooleanOptions() {
        HashMap<String, DataPumpOption> opts = new HashMap<String, DataPumpOption>();
        for (Map.Entry<String, DataPumpOption> entry : options.entrySet()) {
            DataPumpOption opt = entry.getValue();
            if (opt.getGenBoolean() == null) continue;
            opts.put(entry.getKey(), entry.getValue());
        }
        return opts;
    }

    public static enum TABLEEXISTS_VALUES {
        TRUNCATE,
        REPLACE,
        APPEND,
        SKIP;

    }

    public static enum ESTIMATE_VALUES {
        BLOCKS,
        STATISTICS;

    }

    public static enum ENCRYPTIONMODE_VALUES {
        DUAL,
        PASSWORD,
        TRANSPARENT;

    }

    public static enum ENCRYPTIONALGORITHM_VALUES {
        AES128,
        AES192,
        AES256;

    }

    public static enum ENCRYPTION_VALUES {
        ALL,
        DATA_ONLY,
        ENCRYPTED_COLUMNS_ONLY,
        METADATA_ONLY,
        NONE;

    }

    public static enum COMPRESSION_VALUES {
        ALL,
        DATA_ONLY,
        METADATA_ONLY,
        NONE;

    }
}

