/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.recovery.model.DatabaseSizes;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetInput;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateProtectedDatabaseDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="databaseSize")
    private final DatabaseSizes databaseSize;
    @JsonProperty(value="databaseSizeInGBs")
    private final Integer databaseSizeInGBs;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="protectionPolicyId")
    private final String protectionPolicyId;
    @JsonProperty(value="recoveryServiceSubnets")
    private final List<RecoveryServiceSubnetInput> recoveryServiceSubnets;
    @JsonProperty(value="isRedoLogsShipped")
    private final Boolean isRedoLogsShipped;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "databaseSize", "databaseSizeInGBs", "password", "protectionPolicyId", "recoveryServiceSubnets", "isRedoLogsShipped", "freeformTags", "definedTags"})
    public UpdateProtectedDatabaseDetails(String displayName, DatabaseSizes databaseSize, Integer databaseSizeInGBs, String password, String protectionPolicyId, List<RecoveryServiceSubnetInput> recoveryServiceSubnets, Boolean isRedoLogsShipped, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.databaseSize = databaseSize;
        this.databaseSizeInGBs = databaseSizeInGBs;
        this.password = password;
        this.protectionPolicyId = protectionPolicyId;
        this.recoveryServiceSubnets = recoveryServiceSubnets;
        this.isRedoLogsShipped = isRedoLogsShipped;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DatabaseSizes getDatabaseSize() {
        return this.databaseSize;
    }

    public Integer getDatabaseSizeInGBs() {
        return this.databaseSizeInGBs;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProtectionPolicyId() {
        return this.protectionPolicyId;
    }

    public List<RecoveryServiceSubnetInput> getRecoveryServiceSubnets() {
        return this.recoveryServiceSubnets;
    }

    public Boolean getIsRedoLogsShipped() {
        return this.isRedoLogsShipped;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateProtectedDatabaseDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", databaseSize=").append(String.valueOf((Object)this.databaseSize));
        sb.append(", databaseSizeInGBs=").append(String.valueOf(this.databaseSizeInGBs));
        sb.append(", password=").append(String.valueOf(this.password));
        sb.append(", protectionPolicyId=").append(String.valueOf(this.protectionPolicyId));
        sb.append(", recoveryServiceSubnets=").append(String.valueOf(this.recoveryServiceSubnets));
        sb.append(", isRedoLogsShipped=").append(String.valueOf(this.isRedoLogsShipped));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateProtectedDatabaseDetails)) {
            return false;
        }
        UpdateProtectedDatabaseDetails other = (UpdateProtectedDatabaseDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.databaseSize, (Object)other.databaseSize) && Objects.equals(this.databaseSizeInGBs, other.databaseSizeInGBs) && Objects.equals(this.password, other.password) && Objects.equals(this.protectionPolicyId, other.protectionPolicyId) && Objects.equals(this.recoveryServiceSubnets, other.recoveryServiceSubnets) && Objects.equals(this.isRedoLogsShipped, other.isRedoLogsShipped) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.databaseSize == null ? 43 : this.databaseSize.hashCode());
        result = result * 59 + (this.databaseSizeInGBs == null ? 43 : this.databaseSizeInGBs.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.protectionPolicyId == null ? 43 : this.protectionPolicyId.hashCode());
        result = result * 59 + (this.recoveryServiceSubnets == null ? 43 : this.recoveryServiceSubnets.hashCode());
        result = result * 59 + (this.isRedoLogsShipped == null ? 43 : this.isRedoLogsShipped.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="databaseSize")
        private DatabaseSizes databaseSize;
        @JsonProperty(value="databaseSizeInGBs")
        private Integer databaseSizeInGBs;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="protectionPolicyId")
        private String protectionPolicyId;
        @JsonProperty(value="recoveryServiceSubnets")
        private List<RecoveryServiceSubnetInput> recoveryServiceSubnets;
        @JsonProperty(value="isRedoLogsShipped")
        private Boolean isRedoLogsShipped;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder databaseSize(DatabaseSizes databaseSize) {
            this.databaseSize = databaseSize;
            this.__explicitlySet__.add("databaseSize");
            return this;
        }

        public Builder databaseSizeInGBs(Integer databaseSizeInGBs) {
            this.databaseSizeInGBs = databaseSizeInGBs;
            this.__explicitlySet__.add("databaseSizeInGBs");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder protectionPolicyId(String protectionPolicyId) {
            this.protectionPolicyId = protectionPolicyId;
            this.__explicitlySet__.add("protectionPolicyId");
            return this;
        }

        public Builder recoveryServiceSubnets(List<RecoveryServiceSubnetInput> recoveryServiceSubnets) {
            this.recoveryServiceSubnets = recoveryServiceSubnets;
            this.__explicitlySet__.add("recoveryServiceSubnets");
            return this;
        }

        public Builder isRedoLogsShipped(Boolean isRedoLogsShipped) {
            this.isRedoLogsShipped = isRedoLogsShipped;
            this.__explicitlySet__.add("isRedoLogsShipped");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateProtectedDatabaseDetails build() {
            UpdateProtectedDatabaseDetails model = new UpdateProtectedDatabaseDetails(this.displayName, this.databaseSize, this.databaseSizeInGBs, this.password, this.protectionPolicyId, this.recoveryServiceSubnets, this.isRedoLogsShipped, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateProtectedDatabaseDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("databaseSize")) {
                this.databaseSize(model.getDatabaseSize());
            }
            if (model.wasPropertyExplicitlySet("databaseSizeInGBs")) {
                this.databaseSizeInGBs(model.getDatabaseSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("protectionPolicyId")) {
                this.protectionPolicyId(model.getProtectionPolicyId());
            }
            if (model.wasPropertyExplicitlySet("recoveryServiceSubnets")) {
                this.recoveryServiceSubnets(model.getRecoveryServiceSubnets());
            }
            if (model.wasPropertyExplicitlySet("isRedoLogsShipped")) {
                this.isRedoLogsShipped(model.getIsRedoLogsShipped());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

