/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bastion.responses;

import com.oracle.bmc.bastion.model.Session;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateSessionResponse
extends BmcResponse {
    private String opcWorkRequestId;
    private String opcRequestId;
    private String location;
    private String etag;
    private Session session;

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEtag() {
        return this.etag;
    }

    public Session getSession() {
        return this.session;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcWorkRequestId", "opcRequestId", "location", "etag", "session"})
    private CreateSessionResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcWorkRequestId, String opcRequestId, String location, String etag, Session session) {
        super(__httpStatusCode__, headers);
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcRequestId = opcRequestId;
        this.location = location;
        this.etag = etag;
        this.session = session;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",session=").append(String.valueOf((Object)this.session));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSessionResponse)) {
            return false;
        }
        CreateSessionResponse other = (CreateSessionResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.location, other.location) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.session, (Object)other.session);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.session == null ? 43 : this.session.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateSessionResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcWorkRequestId;
        private String opcRequestId;
        private String location;
        private String etag;
        private Session session;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder session(Session session) {
            this.session = session;
            return this;
        }

        public Builder copy(CreateSessionResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.location(o.getLocation());
            this.etag(o.getEtag());
            this.session(o.getSession());
            return this;
        }

        public CreateSessionResponse build() {
            return new CreateSessionResponse(this.__httpStatusCode__, this.headers, this.opcWorkRequestId, this.opcRequestId, this.location, this.etag, this.session);
        }
    }
}

