/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bastion;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.bastion.BastionAsync;
import com.oracle.bmc.bastion.model.Bastion;
import com.oracle.bmc.bastion.model.BastionSummary;
import com.oracle.bmc.bastion.model.Session;
import com.oracle.bmc.bastion.model.SessionSummary;
import com.oracle.bmc.bastion.model.WorkRequest;
import com.oracle.bmc.bastion.model.WorkRequestError;
import com.oracle.bmc.bastion.model.WorkRequestLogEntry;
import com.oracle.bmc.bastion.model.WorkRequestSummary;
import com.oracle.bmc.bastion.requests.ChangeBastionCompartmentRequest;
import com.oracle.bmc.bastion.requests.CreateBastionRequest;
import com.oracle.bmc.bastion.requests.CreateSessionRequest;
import com.oracle.bmc.bastion.requests.DeleteBastionRequest;
import com.oracle.bmc.bastion.requests.DeleteSessionRequest;
import com.oracle.bmc.bastion.requests.GetBastionRequest;
import com.oracle.bmc.bastion.requests.GetSessionRequest;
import com.oracle.bmc.bastion.requests.GetWorkRequestRequest;
import com.oracle.bmc.bastion.requests.ListBastionsRequest;
import com.oracle.bmc.bastion.requests.ListSessionsRequest;
import com.oracle.bmc.bastion.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.bastion.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.bastion.requests.ListWorkRequestsRequest;
import com.oracle.bmc.bastion.requests.UpdateBastionRequest;
import com.oracle.bmc.bastion.requests.UpdateSessionRequest;
import com.oracle.bmc.bastion.responses.ChangeBastionCompartmentResponse;
import com.oracle.bmc.bastion.responses.CreateBastionResponse;
import com.oracle.bmc.bastion.responses.CreateSessionResponse;
import com.oracle.bmc.bastion.responses.DeleteBastionResponse;
import com.oracle.bmc.bastion.responses.DeleteSessionResponse;
import com.oracle.bmc.bastion.responses.GetBastionResponse;
import com.oracle.bmc.bastion.responses.GetSessionResponse;
import com.oracle.bmc.bastion.responses.GetWorkRequestResponse;
import com.oracle.bmc.bastion.responses.ListBastionsResponse;
import com.oracle.bmc.bastion.responses.ListSessionsResponse;
import com.oracle.bmc.bastion.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.bastion.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.bastion.responses.ListWorkRequestsResponse;
import com.oracle.bmc.bastion.responses.UpdateBastionResponse;
import com.oracle.bmc.bastion.responses.UpdateSessionResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BastionAsyncClient
extends BaseAsyncClient
implements BastionAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BASTION").serviceEndpointPrefix("").serviceEndpointTemplate("https://bastion.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(BastionAsyncClient.class);

    BastionAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeBastionCompartmentResponse> changeBastionCompartment(ChangeBastionCompartmentRequest request, AsyncHandler<ChangeBastionCompartmentRequest, ChangeBastionCompartmentResponse> handler) {
        Validate.notBlank((String)request.getBastionId(), (String)"bastionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeBastionCompartmentDetails(), "changeBastionCompartmentDetails is required");
        return this.clientCall(request, ChangeBastionCompartmentResponse::builder).logger(LOG, "changeBastionCompartment").serviceDetails("Bastion", "ChangeBastionCompartment", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Bastion/ChangeBastionCompartment").method(Method.POST).requestBuilder(ChangeBastionCompartmentRequest::builder).basePath("/20210331").appendPathParam("bastions").appendPathParam(request.getBastionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeBastionCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateBastionResponse> createBastion(CreateBastionRequest request, AsyncHandler<CreateBastionRequest, CreateBastionResponse> handler) {
        Objects.requireNonNull(request.getCreateBastionDetails(), "createBastionDetails is required");
        return this.clientCall(request, CreateBastionResponse::builder).logger(LOG, "createBastion").serviceDetails("Bastion", "CreateBastion", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Bastion/CreateBastion").method(Method.POST).requestBuilder(CreateBastionRequest::builder).basePath("/20210331").appendPathParam("bastions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Bastion.class, CreateBastionResponse.Builder::bastion).handleResponseHeaderString("opc-work-request-id", CreateBastionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBastionResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateBastionResponse.Builder::location).handleResponseHeaderString("etag", CreateBastionResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateSessionResponse> createSession(CreateSessionRequest request, AsyncHandler<CreateSessionRequest, CreateSessionResponse> handler) {
        Objects.requireNonNull(request.getCreateSessionDetails(), "createSessionDetails is required");
        return this.clientCall(request, CreateSessionResponse::builder).logger(LOG, "createSession").serviceDetails("Bastion", "CreateSession", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Session/CreateSession").method(Method.POST).requestBuilder(CreateSessionRequest::builder).basePath("/20210331").appendPathParam("sessions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Session.class, CreateSessionResponse.Builder::session).handleResponseHeaderString("opc-work-request-id", CreateSessionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSessionResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateSessionResponse.Builder::location).handleResponseHeaderString("etag", CreateSessionResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteBastionResponse> deleteBastion(DeleteBastionRequest request, AsyncHandler<DeleteBastionRequest, DeleteBastionResponse> handler) {
        Validate.notBlank((String)request.getBastionId(), (String)"bastionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteBastionResponse::builder).logger(LOG, "deleteBastion").serviceDetails("Bastion", "DeleteBastion", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Bastion/DeleteBastion").method(Method.DELETE).requestBuilder(DeleteBastionRequest::builder).basePath("/20210331").appendPathParam("bastions").appendPathParam(request.getBastionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteBastionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBastionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSessionResponse> deleteSession(DeleteSessionRequest request, AsyncHandler<DeleteSessionRequest, DeleteSessionResponse> handler) {
        Validate.notBlank((String)request.getSessionId(), (String)"sessionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSessionResponse::builder).logger(LOG, "deleteSession").serviceDetails("Bastion", "DeleteSession", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Session/DeleteSession").method(Method.DELETE).requestBuilder(DeleteSessionRequest::builder).basePath("/20210331").appendPathParam("sessions").appendPathParam(request.getSessionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteSessionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteSessionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBastionResponse> getBastion(GetBastionRequest request, AsyncHandler<GetBastionRequest, GetBastionResponse> handler) {
        Validate.notBlank((String)request.getBastionId(), (String)"bastionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBastionResponse::builder).logger(LOG, "getBastion").serviceDetails("Bastion", "GetBastion", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Bastion/GetBastion").method(Method.GET).requestBuilder(GetBastionRequest::builder).basePath("/20210331").appendPathParam("bastions").appendPathParam(request.getBastionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Bastion.class, GetBastionResponse.Builder::bastion).handleResponseHeaderString("etag", GetBastionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBastionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSessionResponse> getSession(GetSessionRequest request, AsyncHandler<GetSessionRequest, GetSessionResponse> handler) {
        Validate.notBlank((String)request.getSessionId(), (String)"sessionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSessionResponse::builder).logger(LOG, "getSession").serviceDetails("Bastion", "GetSession", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Session/GetSession").method(Method.GET).requestBuilder(GetSessionRequest::builder).basePath("/20210331").appendPathParam("sessions").appendPathParam(request.getSessionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Session.class, GetSessionResponse.Builder::session).handleResponseHeaderString("etag", GetSessionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSessionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Bastion", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListBastionsResponse> listBastions(ListBastionsRequest request, AsyncHandler<ListBastionsRequest, ListBastionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListBastionsResponse::builder).logger(LOG, "listBastions").serviceDetails("Bastion", "ListBastions", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Bastion/ListBastions").method(Method.GET).requestBuilder(ListBastionsRequest::builder).basePath("/20210331").appendPathParam("bastions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("bastionLifecycleState", (BmcEnum)request.getBastionLifecycleState()).appendQueryParam("bastionId", (Object)request.getBastionId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(BastionSummary.class, ListBastionsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBastionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBastionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSessionsResponse> listSessions(ListSessionsRequest request, AsyncHandler<ListSessionsRequest, ListSessionsResponse> handler) {
        Objects.requireNonNull(request.getBastionId(), "bastionId is required");
        return this.clientCall(request, ListSessionsResponse::builder).logger(LOG, "listSessions").serviceDetails("Bastion", "ListSessions", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Session/ListSessions").method(Method.GET).requestBuilder(ListSessionsRequest::builder).basePath("/20210331").appendPathParam("sessions").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("bastionId", (Object)request.getBastionId()).appendEnumQueryParam("sessionLifecycleState", (BmcEnum)request.getSessionLifecycleState()).appendQueryParam("sessionId", (Object)request.getSessionId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SessionSummary.class, ListSessionsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSessionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSessionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Bastion", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Bastion", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Bastion", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210331").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateBastionResponse> updateBastion(UpdateBastionRequest request, AsyncHandler<UpdateBastionRequest, UpdateBastionResponse> handler) {
        Validate.notBlank((String)request.getBastionId(), (String)"bastionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBastionDetails(), "updateBastionDetails is required");
        return this.clientCall(request, UpdateBastionResponse::builder).logger(LOG, "updateBastion").serviceDetails("Bastion", "UpdateBastion", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Bastion/UpdateBastion").method(Method.PUT).requestBuilder(UpdateBastionRequest::builder).basePath("/20210331").appendPathParam("bastions").appendPathParam(request.getBastionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateBastionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateBastionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSessionResponse> updateSession(UpdateSessionRequest request, AsyncHandler<UpdateSessionRequest, UpdateSessionResponse> handler) {
        Validate.notBlank((String)request.getSessionId(), (String)"sessionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSessionDetails(), "updateSessionDetails is required");
        return this.clientCall(request, UpdateSessionResponse::builder).logger(LOG, "updateSession").serviceDetails("Bastion", "UpdateSession", "https://docs.oracle.com/iaas/api/#/en/bastion/20210331/Session/UpdateSession").method(Method.PUT).requestBuilder(UpdateSessionRequest::builder).basePath("/20210331").appendPathParam("sessions").appendPathParam(request.getSessionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Session.class, UpdateSessionResponse.Builder::session).handleResponseHeaderString("etag", UpdateSessionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSessionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public BastionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)BastionAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BastionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(BastionAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BastionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)BastionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BastionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)BastionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public BastionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)BastionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public BastionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)BastionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public BastionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BastionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BastionAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "bastion";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"bastion");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public BastionAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new BastionAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

