/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.core.model.IpInventoryCollection;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListIpInventoryResponse
extends BmcResponse {
    private String etag;
    private String opcNextPage;
    private String opcRequestId;
    private Integer opcTotalItems;
    private String opcWorkRequestId;
    private LifecycleState lifecycleState;
    private String dataRequestId;
    private IpInventoryCollection ipInventoryCollection;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDataRequestId() {
        return this.dataRequestId;
    }

    public IpInventoryCollection getIpInventoryCollection() {
        return this.ipInventoryCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcNextPage", "opcRequestId", "opcTotalItems", "opcWorkRequestId", "lifecycleState", "dataRequestId", "ipInventoryCollection"})
    private ListIpInventoryResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcNextPage, String opcRequestId, Integer opcTotalItems, String opcWorkRequestId, LifecycleState lifecycleState, String dataRequestId, IpInventoryCollection ipInventoryCollection) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.opcTotalItems = opcTotalItems;
        this.opcWorkRequestId = opcWorkRequestId;
        this.lifecycleState = lifecycleState;
        this.dataRequestId = dataRequestId;
        this.ipInventoryCollection = ipInventoryCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcTotalItems=").append(String.valueOf(this.opcTotalItems));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",dataRequestId=").append(String.valueOf(this.dataRequestId));
        sb.append(",ipInventoryCollection=").append(String.valueOf((Object)this.ipInventoryCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListIpInventoryResponse)) {
            return false;
        }
        ListIpInventoryResponse other = (ListIpInventoryResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcTotalItems, other.opcTotalItems) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.dataRequestId, other.dataRequestId) && Objects.equals((Object)this.ipInventoryCollection, (Object)other.ipInventoryCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcTotalItems == null ? 43 : this.opcTotalItems.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.dataRequestId == null ? 43 : this.dataRequestId.hashCode());
        result = result * 59 + (this.ipInventoryCollection == null ? 43 : this.ipInventoryCollection.hashCode());
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        InProgress("IN_PROGRESS"),
        Done("DONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcResponse.Builder<ListIpInventoryResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcNextPage;
        private String opcRequestId;
        private Integer opcTotalItems;
        private String opcWorkRequestId;
        private LifecycleState lifecycleState;
        private String dataRequestId;
        private IpInventoryCollection ipInventoryCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder dataRequestId(String dataRequestId) {
            this.dataRequestId = dataRequestId;
            return this;
        }

        public Builder ipInventoryCollection(IpInventoryCollection ipInventoryCollection) {
            this.ipInventoryCollection = ipInventoryCollection;
            return this;
        }

        public Builder copy(ListIpInventoryResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.opcTotalItems(o.getOpcTotalItems());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.lifecycleState(o.getLifecycleState());
            this.dataRequestId(o.getDataRequestId());
            this.ipInventoryCollection(o.getIpInventoryCollection());
            return this;
        }

        public ListIpInventoryResponse build() {
            return new ListIpInventoryResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcNextPage, this.opcRequestId, this.opcTotalItems, this.opcWorkRequestId, this.lifecycleState, this.dataRequestId, this.ipInventoryCollection);
        }
    }
}

