/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListPublicIpsRequest
extends BmcRequest<Void> {
    private Scope scope;
    private String compartmentId;
    private Integer limit;
    private String page;
    private String availabilityDomain;
    private Lifetime lifetime;
    private String publicIpPoolId;

    public Scope getScope() {
        return this.scope;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public String getPublicIpPoolId() {
        return this.publicIpPoolId;
    }

    public Builder toBuilder() {
        return new Builder().scope(this.scope).compartmentId(this.compartmentId).limit(this.limit).page(this.page).availabilityDomain(this.availabilityDomain).lifetime(this.lifetime).publicIpPoolId(this.publicIpPoolId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(",lifetime=").append(String.valueOf((Object)this.lifetime));
        sb.append(",publicIpPoolId=").append(String.valueOf(this.publicIpPoolId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPublicIpsRequest)) {
            return false;
        }
        ListPublicIpsRequest other = (ListPublicIpsRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals((Object)this.lifetime, (Object)other.lifetime) && Objects.equals(this.publicIpPoolId, other.publicIpPoolId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.lifetime == null ? 43 : this.lifetime.hashCode());
        result = result * 59 + (this.publicIpPoolId == null ? 43 : this.publicIpPoolId.hashCode());
        return result;
    }

    public static enum Lifetime implements BmcEnum
    {
        Ephemeral("EPHEMERAL"),
        Reserved("RESERVED");

        private final String value;
        private static Map<String, Lifetime> map;

        private Lifetime(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Lifetime create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Lifetime: " + key);
        }

        static {
            map = new HashMap<String, Lifetime>();
            for (Lifetime v : Lifetime.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Scope implements BmcEnum
    {
        Region("REGION"),
        AvailabilityDomain("AVAILABILITY_DOMAIN");

        private final String value;
        private static Map<String, Scope> map;

        private Scope(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Scope create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Scope: " + key);
        }

        static {
            map = new HashMap<String, Scope>();
            for (Scope v : Scope.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcRequest.Builder<ListPublicIpsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private Scope scope = null;
        private String compartmentId = null;
        private Integer limit = null;
        private String page = null;
        private String availabilityDomain = null;
        private Lifetime lifetime = null;
        private String publicIpPoolId = null;

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder lifetime(Lifetime lifetime) {
            this.lifetime = lifetime;
            return this;
        }

        public Builder publicIpPoolId(String publicIpPoolId) {
            this.publicIpPoolId = publicIpPoolId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPublicIpsRequest o) {
            this.scope(o.getScope());
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.lifetime(o.getLifetime());
            this.publicIpPoolId(o.getPublicIpPoolId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPublicIpsRequest build() {
            ListPublicIpsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListPublicIpsRequest buildWithoutInvocationCallback() {
            ListPublicIpsRequest request = new ListPublicIpsRequest();
            request.scope = this.scope;
            request.compartmentId = this.compartmentId;
            request.limit = this.limit;
            request.page = this.page;
            request.availabilityDomain = this.availabilityDomain;
            request.lifetime = this.lifetime;
            request.publicIpPoolId = this.publicIpPoolId;
            return request;
        }
    }
}

