/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAppCatalogListingsRequest
extends BmcRequest<Void> {
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private String publisherName;
    private String publisherType;
    private String displayName;

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String getPublisherType() {
        return this.publisherType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new Builder().limit(this.limit).page(this.page).sortOrder(this.sortOrder).publisherName(this.publisherName).publisherType(this.publisherType).displayName(this.displayName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",publisherName=").append(String.valueOf(this.publisherName));
        sb.append(",publisherType=").append(String.valueOf(this.publisherType));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAppCatalogListingsRequest)) {
            return false;
        }
        ListAppCatalogListingsRequest other = (ListAppCatalogListingsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.publisherName, other.publisherName) && Objects.equals(this.publisherType, other.publisherType) && Objects.equals(this.displayName, other.displayName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.publisherName == null ? 43 : this.publisherName.hashCode());
        result = result * 59 + (this.publisherType == null ? 43 : this.publisherType.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        return result;
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcRequest.Builder<ListAppCatalogListingsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private String publisherName = null;
        private String publisherType = null;
        private String displayName = null;

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            return this;
        }

        public Builder publisherType(String publisherType) {
            this.publisherType = publisherType;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAppCatalogListingsRequest o) {
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.publisherName(o.getPublisherName());
            this.publisherType(o.getPublisherType());
            this.displayName(o.getDisplayName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAppCatalogListingsRequest build() {
            ListAppCatalogListingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAppCatalogListingsRequest buildWithoutInvocationCallback() {
            ListAppCatalogListingsRequest request = new ListAppCatalogListingsRequest();
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.publisherName = this.publisherName;
            request.publisherType = this.publisherType;
            request.displayName = this.displayName;
            return request;
        }
    }
}

