/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetInstanceMaintenanceEventRequest
extends BmcRequest<Void> {
    private String instanceMaintenanceEventId;
    private String opcRequestId;

    public String getInstanceMaintenanceEventId() {
        return this.instanceMaintenanceEventId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().instanceMaintenanceEventId(this.instanceMaintenanceEventId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceMaintenanceEventId=").append(String.valueOf(this.instanceMaintenanceEventId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetInstanceMaintenanceEventRequest)) {
            return false;
        }
        GetInstanceMaintenanceEventRequest other = (GetInstanceMaintenanceEventRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceMaintenanceEventId, other.instanceMaintenanceEventId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceMaintenanceEventId == null ? 43 : this.instanceMaintenanceEventId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInstanceMaintenanceEventRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceMaintenanceEventId = null;
        private String opcRequestId = null;

        public Builder instanceMaintenanceEventId(String instanceMaintenanceEventId) {
            this.instanceMaintenanceEventId = instanceMaintenanceEventId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstanceMaintenanceEventRequest o) {
            this.instanceMaintenanceEventId(o.getInstanceMaintenanceEventId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstanceMaintenanceEventRequest build() {
            GetInstanceMaintenanceEventRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetInstanceMaintenanceEventRequest buildWithoutInvocationCallback() {
            GetInstanceMaintenanceEventRequest request = new GetInstanceMaintenanceEventRequest();
            request.instanceMaintenanceEventId = this.instanceMaintenanceEventId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

