/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VirtualCircuitRedundancyMetadata
extends ExplicitlySetBmcModel {
    @JsonProperty(value="configuredRedundancyLevel")
    private final ConfiguredRedundancyLevel configuredRedundancyLevel;
    @JsonProperty(value="ipv4bgpSessionRedundancyStatus")
    private final Ipv4bgpSessionRedundancyStatus ipv4bgpSessionRedundancyStatus;
    @JsonProperty(value="ipv6bgpSessionRedundancyStatus")
    private final Ipv6bgpSessionRedundancyStatus ipv6bgpSessionRedundancyStatus;

    @Deprecated
    @ConstructorProperties(value={"configuredRedundancyLevel", "ipv4bgpSessionRedundancyStatus", "ipv6bgpSessionRedundancyStatus"})
    public VirtualCircuitRedundancyMetadata(ConfiguredRedundancyLevel configuredRedundancyLevel, Ipv4bgpSessionRedundancyStatus ipv4bgpSessionRedundancyStatus, Ipv6bgpSessionRedundancyStatus ipv6bgpSessionRedundancyStatus) {
        this.configuredRedundancyLevel = configuredRedundancyLevel;
        this.ipv4bgpSessionRedundancyStatus = ipv4bgpSessionRedundancyStatus;
        this.ipv6bgpSessionRedundancyStatus = ipv6bgpSessionRedundancyStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ConfiguredRedundancyLevel getConfiguredRedundancyLevel() {
        return this.configuredRedundancyLevel;
    }

    public Ipv4bgpSessionRedundancyStatus getIpv4bgpSessionRedundancyStatus() {
        return this.ipv4bgpSessionRedundancyStatus;
    }

    public Ipv6bgpSessionRedundancyStatus getIpv6bgpSessionRedundancyStatus() {
        return this.ipv6bgpSessionRedundancyStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualCircuitRedundancyMetadata(");
        sb.append("super=").append(super.toString());
        sb.append("configuredRedundancyLevel=").append(String.valueOf((Object)this.configuredRedundancyLevel));
        sb.append(", ipv4bgpSessionRedundancyStatus=").append(String.valueOf((Object)this.ipv4bgpSessionRedundancyStatus));
        sb.append(", ipv6bgpSessionRedundancyStatus=").append(String.valueOf((Object)this.ipv6bgpSessionRedundancyStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualCircuitRedundancyMetadata)) {
            return false;
        }
        VirtualCircuitRedundancyMetadata other = (VirtualCircuitRedundancyMetadata)((Object)o);
        return Objects.equals((Object)this.configuredRedundancyLevel, (Object)other.configuredRedundancyLevel) && Objects.equals((Object)this.ipv4bgpSessionRedundancyStatus, (Object)other.ipv4bgpSessionRedundancyStatus) && Objects.equals((Object)this.ipv6bgpSessionRedundancyStatus, (Object)other.ipv6bgpSessionRedundancyStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.configuredRedundancyLevel == null ? 43 : this.configuredRedundancyLevel.hashCode());
        result = result * 59 + (this.ipv4bgpSessionRedundancyStatus == null ? 43 : this.ipv4bgpSessionRedundancyStatus.hashCode());
        result = result * 59 + (this.ipv6bgpSessionRedundancyStatus == null ? 43 : this.ipv6bgpSessionRedundancyStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConfiguredRedundancyLevel implements BmcEnum
    {
        Device("DEVICE"),
        Pop("POP"),
        Region("REGION"),
        NonRedundant("NON_REDUNDANT"),
        Pending("PENDING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConfiguredRedundancyLevel> map;

        private ConfiguredRedundancyLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConfiguredRedundancyLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConfiguredRedundancyLevel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConfiguredRedundancyLevel.class);
            map = new HashMap<String, ConfiguredRedundancyLevel>();
            for (ConfiguredRedundancyLevel v : ConfiguredRedundancyLevel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Ipv4bgpSessionRedundancyStatus implements BmcEnum
    {
        ConfigurationMatch("CONFIGURATION_MATCH"),
        ConfigurationMismatch("CONFIGURATION_MISMATCH"),
        NotMetSla("NOT_MET_SLA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Ipv4bgpSessionRedundancyStatus> map;

        private Ipv4bgpSessionRedundancyStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Ipv4bgpSessionRedundancyStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Ipv4bgpSessionRedundancyStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Ipv4bgpSessionRedundancyStatus.class);
            map = new HashMap<String, Ipv4bgpSessionRedundancyStatus>();
            for (Ipv4bgpSessionRedundancyStatus v : Ipv4bgpSessionRedundancyStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Ipv6bgpSessionRedundancyStatus implements BmcEnum
    {
        ConfigurationMatch("CONFIGURATION_MATCH"),
        ConfigurationMismatch("CONFIGURATION_MISMATCH"),
        NotMetSla("NOT_MET_SLA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Ipv6bgpSessionRedundancyStatus> map;

        private Ipv6bgpSessionRedundancyStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Ipv6bgpSessionRedundancyStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Ipv6bgpSessionRedundancyStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Ipv6bgpSessionRedundancyStatus.class);
            map = new HashMap<String, Ipv6bgpSessionRedundancyStatus>();
            for (Ipv6bgpSessionRedundancyStatus v : Ipv6bgpSessionRedundancyStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="configuredRedundancyLevel")
        private ConfiguredRedundancyLevel configuredRedundancyLevel;
        @JsonProperty(value="ipv4bgpSessionRedundancyStatus")
        private Ipv4bgpSessionRedundancyStatus ipv4bgpSessionRedundancyStatus;
        @JsonProperty(value="ipv6bgpSessionRedundancyStatus")
        private Ipv6bgpSessionRedundancyStatus ipv6bgpSessionRedundancyStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder configuredRedundancyLevel(ConfiguredRedundancyLevel configuredRedundancyLevel) {
            this.configuredRedundancyLevel = configuredRedundancyLevel;
            this.__explicitlySet__.add("configuredRedundancyLevel");
            return this;
        }

        public Builder ipv4bgpSessionRedundancyStatus(Ipv4bgpSessionRedundancyStatus ipv4bgpSessionRedundancyStatus) {
            this.ipv4bgpSessionRedundancyStatus = ipv4bgpSessionRedundancyStatus;
            this.__explicitlySet__.add("ipv4bgpSessionRedundancyStatus");
            return this;
        }

        public Builder ipv6bgpSessionRedundancyStatus(Ipv6bgpSessionRedundancyStatus ipv6bgpSessionRedundancyStatus) {
            this.ipv6bgpSessionRedundancyStatus = ipv6bgpSessionRedundancyStatus;
            this.__explicitlySet__.add("ipv6bgpSessionRedundancyStatus");
            return this;
        }

        public VirtualCircuitRedundancyMetadata build() {
            VirtualCircuitRedundancyMetadata model = new VirtualCircuitRedundancyMetadata(this.configuredRedundancyLevel, this.ipv4bgpSessionRedundancyStatus, this.ipv6bgpSessionRedundancyStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VirtualCircuitRedundancyMetadata model) {
            if (model.wasPropertyExplicitlySet("configuredRedundancyLevel")) {
                this.configuredRedundancyLevel(model.getConfiguredRedundancyLevel());
            }
            if (model.wasPropertyExplicitlySet("ipv4bgpSessionRedundancyStatus")) {
                this.ipv4bgpSessionRedundancyStatus(model.getIpv4bgpSessionRedundancyStatus());
            }
            if (model.wasPropertyExplicitlySet("ipv6bgpSessionRedundancyStatus")) {
                this.ipv6bgpSessionRedundancyStatus(model.getIpv6bgpSessionRedundancyStatus());
            }
            return this;
        }
    }
}

