/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.IpInventorySubnetResourceSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IpInventorySubnetResourceCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="count")
    private final Integer count;
    @JsonProperty(value="lastUpdatedTimestamp")
    private final Date lastUpdatedTimestamp;
    @JsonProperty(value="ipInventorySubnetResourceSummary")
    private final List<IpInventorySubnetResourceSummary> ipInventorySubnetResourceSummary;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;

    @Deprecated
    @ConstructorProperties(value={"count", "lastUpdatedTimestamp", "ipInventorySubnetResourceSummary", "message", "compartmentId"})
    public IpInventorySubnetResourceCollection(Integer count, Date lastUpdatedTimestamp, List<IpInventorySubnetResourceSummary> ipInventorySubnetResourceSummary, String message, String compartmentId) {
        this.count = count;
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        this.ipInventorySubnetResourceSummary = ipInventorySubnetResourceSummary;
        this.message = message;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getCount() {
        return this.count;
    }

    public Date getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public List<IpInventorySubnetResourceSummary> getIpInventorySubnetResourceSummary() {
        return this.ipInventorySubnetResourceSummary;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IpInventorySubnetResourceCollection(");
        sb.append("super=").append(super.toString());
        sb.append("count=").append(String.valueOf(this.count));
        sb.append(", lastUpdatedTimestamp=").append(String.valueOf(this.lastUpdatedTimestamp));
        sb.append(", ipInventorySubnetResourceSummary=").append(String.valueOf(this.ipInventorySubnetResourceSummary));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpInventorySubnetResourceCollection)) {
            return false;
        }
        IpInventorySubnetResourceCollection other = (IpInventorySubnetResourceCollection)((Object)o);
        return Objects.equals(this.count, other.count) && Objects.equals(this.lastUpdatedTimestamp, other.lastUpdatedTimestamp) && Objects.equals(this.ipInventorySubnetResourceSummary, other.ipInventorySubnetResourceSummary) && Objects.equals(this.message, other.message) && Objects.equals(this.compartmentId, other.compartmentId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + (this.lastUpdatedTimestamp == null ? 43 : this.lastUpdatedTimestamp.hashCode());
        result = result * 59 + (this.ipInventorySubnetResourceSummary == null ? 43 : this.ipInventorySubnetResourceSummary.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="count")
        private Integer count;
        @JsonProperty(value="lastUpdatedTimestamp")
        private Date lastUpdatedTimestamp;
        @JsonProperty(value="ipInventorySubnetResourceSummary")
        private List<IpInventorySubnetResourceSummary> ipInventorySubnetResourceSummary;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public Builder lastUpdatedTimestamp(Date lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            this.__explicitlySet__.add("lastUpdatedTimestamp");
            return this;
        }

        public Builder ipInventorySubnetResourceSummary(List<IpInventorySubnetResourceSummary> ipInventorySubnetResourceSummary) {
            this.ipInventorySubnetResourceSummary = ipInventorySubnetResourceSummary;
            this.__explicitlySet__.add("ipInventorySubnetResourceSummary");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public IpInventorySubnetResourceCollection build() {
            IpInventorySubnetResourceCollection model = new IpInventorySubnetResourceCollection(this.count, this.lastUpdatedTimestamp, this.ipInventorySubnetResourceSummary, this.message, this.compartmentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IpInventorySubnetResourceCollection model) {
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            if (model.wasPropertyExplicitlySet("lastUpdatedTimestamp")) {
                this.lastUpdatedTimestamp(model.getLastUpdatedTimestamp());
            }
            if (model.wasPropertyExplicitlySet("ipInventorySubnetResourceSummary")) {
                this.ipInventorySubnetResourceSummary(model.getIpInventorySubnetResourceSummary());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            return this;
        }
    }
}

