/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CrossConnectMappingDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bgpMd5AuthKey")
    private final String bgpMd5AuthKey;
    @JsonProperty(value="crossConnectOrCrossConnectGroupId")
    private final String crossConnectOrCrossConnectGroupId;
    @JsonProperty(value="customerBgpPeeringIp")
    private final String customerBgpPeeringIp;
    @JsonProperty(value="oracleBgpPeeringIp")
    private final String oracleBgpPeeringIp;
    @JsonProperty(value="customerBgpPeeringIpv6")
    private final String customerBgpPeeringIpv6;
    @JsonProperty(value="oracleBgpPeeringIpv6")
    private final String oracleBgpPeeringIpv6;
    @JsonProperty(value="vlan")
    private final Integer vlan;
    @JsonProperty(value="ipv4BgpStatus")
    private final Ipv4BgpStatus ipv4BgpStatus;
    @JsonProperty(value="ipv6BgpStatus")
    private final Ipv6BgpStatus ipv6BgpStatus;
    @JsonProperty(value="ociLogicalDeviceName")
    private final String ociLogicalDeviceName;

    @Deprecated
    @ConstructorProperties(value={"bgpMd5AuthKey", "crossConnectOrCrossConnectGroupId", "customerBgpPeeringIp", "oracleBgpPeeringIp", "customerBgpPeeringIpv6", "oracleBgpPeeringIpv6", "vlan", "ipv4BgpStatus", "ipv6BgpStatus", "ociLogicalDeviceName"})
    public CrossConnectMappingDetails(String bgpMd5AuthKey, String crossConnectOrCrossConnectGroupId, String customerBgpPeeringIp, String oracleBgpPeeringIp, String customerBgpPeeringIpv6, String oracleBgpPeeringIpv6, Integer vlan, Ipv4BgpStatus ipv4BgpStatus, Ipv6BgpStatus ipv6BgpStatus, String ociLogicalDeviceName) {
        this.bgpMd5AuthKey = bgpMd5AuthKey;
        this.crossConnectOrCrossConnectGroupId = crossConnectOrCrossConnectGroupId;
        this.customerBgpPeeringIp = customerBgpPeeringIp;
        this.oracleBgpPeeringIp = oracleBgpPeeringIp;
        this.customerBgpPeeringIpv6 = customerBgpPeeringIpv6;
        this.oracleBgpPeeringIpv6 = oracleBgpPeeringIpv6;
        this.vlan = vlan;
        this.ipv4BgpStatus = ipv4BgpStatus;
        this.ipv6BgpStatus = ipv6BgpStatus;
        this.ociLogicalDeviceName = ociLogicalDeviceName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBgpMd5AuthKey() {
        return this.bgpMd5AuthKey;
    }

    public String getCrossConnectOrCrossConnectGroupId() {
        return this.crossConnectOrCrossConnectGroupId;
    }

    public String getCustomerBgpPeeringIp() {
        return this.customerBgpPeeringIp;
    }

    public String getOracleBgpPeeringIp() {
        return this.oracleBgpPeeringIp;
    }

    public String getCustomerBgpPeeringIpv6() {
        return this.customerBgpPeeringIpv6;
    }

    public String getOracleBgpPeeringIpv6() {
        return this.oracleBgpPeeringIpv6;
    }

    public Integer getVlan() {
        return this.vlan;
    }

    public Ipv4BgpStatus getIpv4BgpStatus() {
        return this.ipv4BgpStatus;
    }

    public Ipv6BgpStatus getIpv6BgpStatus() {
        return this.ipv6BgpStatus;
    }

    public String getOciLogicalDeviceName() {
        return this.ociLogicalDeviceName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CrossConnectMappingDetails(");
        sb.append("super=").append(super.toString());
        sb.append("bgpMd5AuthKey=").append(String.valueOf(this.bgpMd5AuthKey));
        sb.append(", crossConnectOrCrossConnectGroupId=").append(String.valueOf(this.crossConnectOrCrossConnectGroupId));
        sb.append(", customerBgpPeeringIp=").append(String.valueOf(this.customerBgpPeeringIp));
        sb.append(", oracleBgpPeeringIp=").append(String.valueOf(this.oracleBgpPeeringIp));
        sb.append(", customerBgpPeeringIpv6=").append(String.valueOf(this.customerBgpPeeringIpv6));
        sb.append(", oracleBgpPeeringIpv6=").append(String.valueOf(this.oracleBgpPeeringIpv6));
        sb.append(", vlan=").append(String.valueOf(this.vlan));
        sb.append(", ipv4BgpStatus=").append(String.valueOf((Object)this.ipv4BgpStatus));
        sb.append(", ipv6BgpStatus=").append(String.valueOf((Object)this.ipv6BgpStatus));
        sb.append(", ociLogicalDeviceName=").append(String.valueOf(this.ociLogicalDeviceName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CrossConnectMappingDetails)) {
            return false;
        }
        CrossConnectMappingDetails other = (CrossConnectMappingDetails)((Object)o);
        return Objects.equals(this.bgpMd5AuthKey, other.bgpMd5AuthKey) && Objects.equals(this.crossConnectOrCrossConnectGroupId, other.crossConnectOrCrossConnectGroupId) && Objects.equals(this.customerBgpPeeringIp, other.customerBgpPeeringIp) && Objects.equals(this.oracleBgpPeeringIp, other.oracleBgpPeeringIp) && Objects.equals(this.customerBgpPeeringIpv6, other.customerBgpPeeringIpv6) && Objects.equals(this.oracleBgpPeeringIpv6, other.oracleBgpPeeringIpv6) && Objects.equals(this.vlan, other.vlan) && Objects.equals((Object)this.ipv4BgpStatus, (Object)other.ipv4BgpStatus) && Objects.equals((Object)this.ipv6BgpStatus, (Object)other.ipv6BgpStatus) && Objects.equals(this.ociLogicalDeviceName, other.ociLogicalDeviceName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bgpMd5AuthKey == null ? 43 : this.bgpMd5AuthKey.hashCode());
        result = result * 59 + (this.crossConnectOrCrossConnectGroupId == null ? 43 : this.crossConnectOrCrossConnectGroupId.hashCode());
        result = result * 59 + (this.customerBgpPeeringIp == null ? 43 : this.customerBgpPeeringIp.hashCode());
        result = result * 59 + (this.oracleBgpPeeringIp == null ? 43 : this.oracleBgpPeeringIp.hashCode());
        result = result * 59 + (this.customerBgpPeeringIpv6 == null ? 43 : this.customerBgpPeeringIpv6.hashCode());
        result = result * 59 + (this.oracleBgpPeeringIpv6 == null ? 43 : this.oracleBgpPeeringIpv6.hashCode());
        result = result * 59 + (this.vlan == null ? 43 : this.vlan.hashCode());
        result = result * 59 + (this.ipv4BgpStatus == null ? 43 : this.ipv4BgpStatus.hashCode());
        result = result * 59 + (this.ipv6BgpStatus == null ? 43 : this.ipv6BgpStatus.hashCode());
        result = result * 59 + (this.ociLogicalDeviceName == null ? 43 : this.ociLogicalDeviceName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Ipv4BgpStatus implements BmcEnum
    {
        Up("UP"),
        Down("DOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Ipv4BgpStatus> map;

        private Ipv4BgpStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Ipv4BgpStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Ipv4BgpStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Ipv4BgpStatus.class);
            map = new HashMap<String, Ipv4BgpStatus>();
            for (Ipv4BgpStatus v : Ipv4BgpStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Ipv6BgpStatus implements BmcEnum
    {
        Up("UP"),
        Down("DOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Ipv6BgpStatus> map;

        private Ipv6BgpStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Ipv6BgpStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Ipv6BgpStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Ipv6BgpStatus.class);
            map = new HashMap<String, Ipv6BgpStatus>();
            for (Ipv6BgpStatus v : Ipv6BgpStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bgpMd5AuthKey")
        private String bgpMd5AuthKey;
        @JsonProperty(value="crossConnectOrCrossConnectGroupId")
        private String crossConnectOrCrossConnectGroupId;
        @JsonProperty(value="customerBgpPeeringIp")
        private String customerBgpPeeringIp;
        @JsonProperty(value="oracleBgpPeeringIp")
        private String oracleBgpPeeringIp;
        @JsonProperty(value="customerBgpPeeringIpv6")
        private String customerBgpPeeringIpv6;
        @JsonProperty(value="oracleBgpPeeringIpv6")
        private String oracleBgpPeeringIpv6;
        @JsonProperty(value="vlan")
        private Integer vlan;
        @JsonProperty(value="ipv4BgpStatus")
        private Ipv4BgpStatus ipv4BgpStatus;
        @JsonProperty(value="ipv6BgpStatus")
        private Ipv6BgpStatus ipv6BgpStatus;
        @JsonProperty(value="ociLogicalDeviceName")
        private String ociLogicalDeviceName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bgpMd5AuthKey(String bgpMd5AuthKey) {
            this.bgpMd5AuthKey = bgpMd5AuthKey;
            this.__explicitlySet__.add("bgpMd5AuthKey");
            return this;
        }

        public Builder crossConnectOrCrossConnectGroupId(String crossConnectOrCrossConnectGroupId) {
            this.crossConnectOrCrossConnectGroupId = crossConnectOrCrossConnectGroupId;
            this.__explicitlySet__.add("crossConnectOrCrossConnectGroupId");
            return this;
        }

        public Builder customerBgpPeeringIp(String customerBgpPeeringIp) {
            this.customerBgpPeeringIp = customerBgpPeeringIp;
            this.__explicitlySet__.add("customerBgpPeeringIp");
            return this;
        }

        public Builder oracleBgpPeeringIp(String oracleBgpPeeringIp) {
            this.oracleBgpPeeringIp = oracleBgpPeeringIp;
            this.__explicitlySet__.add("oracleBgpPeeringIp");
            return this;
        }

        public Builder customerBgpPeeringIpv6(String customerBgpPeeringIpv6) {
            this.customerBgpPeeringIpv6 = customerBgpPeeringIpv6;
            this.__explicitlySet__.add("customerBgpPeeringIpv6");
            return this;
        }

        public Builder oracleBgpPeeringIpv6(String oracleBgpPeeringIpv6) {
            this.oracleBgpPeeringIpv6 = oracleBgpPeeringIpv6;
            this.__explicitlySet__.add("oracleBgpPeeringIpv6");
            return this;
        }

        public Builder vlan(Integer vlan) {
            this.vlan = vlan;
            this.__explicitlySet__.add("vlan");
            return this;
        }

        public Builder ipv4BgpStatus(Ipv4BgpStatus ipv4BgpStatus) {
            this.ipv4BgpStatus = ipv4BgpStatus;
            this.__explicitlySet__.add("ipv4BgpStatus");
            return this;
        }

        public Builder ipv6BgpStatus(Ipv6BgpStatus ipv6BgpStatus) {
            this.ipv6BgpStatus = ipv6BgpStatus;
            this.__explicitlySet__.add("ipv6BgpStatus");
            return this;
        }

        public Builder ociLogicalDeviceName(String ociLogicalDeviceName) {
            this.ociLogicalDeviceName = ociLogicalDeviceName;
            this.__explicitlySet__.add("ociLogicalDeviceName");
            return this;
        }

        public CrossConnectMappingDetails build() {
            CrossConnectMappingDetails model = new CrossConnectMappingDetails(this.bgpMd5AuthKey, this.crossConnectOrCrossConnectGroupId, this.customerBgpPeeringIp, this.oracleBgpPeeringIp, this.customerBgpPeeringIpv6, this.oracleBgpPeeringIpv6, this.vlan, this.ipv4BgpStatus, this.ipv6BgpStatus, this.ociLogicalDeviceName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CrossConnectMappingDetails model) {
            if (model.wasPropertyExplicitlySet("bgpMd5AuthKey")) {
                this.bgpMd5AuthKey(model.getBgpMd5AuthKey());
            }
            if (model.wasPropertyExplicitlySet("crossConnectOrCrossConnectGroupId")) {
                this.crossConnectOrCrossConnectGroupId(model.getCrossConnectOrCrossConnectGroupId());
            }
            if (model.wasPropertyExplicitlySet("customerBgpPeeringIp")) {
                this.customerBgpPeeringIp(model.getCustomerBgpPeeringIp());
            }
            if (model.wasPropertyExplicitlySet("oracleBgpPeeringIp")) {
                this.oracleBgpPeeringIp(model.getOracleBgpPeeringIp());
            }
            if (model.wasPropertyExplicitlySet("customerBgpPeeringIpv6")) {
                this.customerBgpPeeringIpv6(model.getCustomerBgpPeeringIpv6());
            }
            if (model.wasPropertyExplicitlySet("oracleBgpPeeringIpv6")) {
                this.oracleBgpPeeringIpv6(model.getOracleBgpPeeringIpv6());
            }
            if (model.wasPropertyExplicitlySet("vlan")) {
                this.vlan(model.getVlan());
            }
            if (model.wasPropertyExplicitlySet("ipv4BgpStatus")) {
                this.ipv4BgpStatus(model.getIpv4BgpStatus());
            }
            if (model.wasPropertyExplicitlySet("ipv6BgpStatus")) {
                this.ipv6BgpStatus(model.getIpv6BgpStatus());
            }
            if (model.wasPropertyExplicitlySet("ociLogicalDeviceName")) {
                this.ociLogicalDeviceName(model.getOciLogicalDeviceName());
            }
            return this;
        }
    }
}

